/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.operations.fields;

import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.services.administration.components.operations.fields.ComponentFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.ComponentFieldOperationRequest;
import com.mulesoft.agent.services.administration.components.operations.fields.executors.ComponentFieldExecutor;
import com.mulesoft.agent.services.administration.components.serialization.ApplicationSerializationStrategy;
import com.mulesoft.agent.services.administration.components.serialization.ComponentSerializationStrategy;
import com.mulesoft.agent.services.administration.exception.FieldExecutorException;
import com.mulesoft.agent.services.administration.exception.FieldOperationException;
import java.util.HashSet;

public abstract class ApplicationFieldOperation
implements ComponentFieldOperation {
    private ComponentFieldOperationRequest request;

    protected ApplicationFieldOperation(ComponentFieldOperationRequest request) {
        this.request = request;
    }

    protected ComponentFieldExecutor getFieldExecutor() {
        return this.request.getFieldExecutor();
    }

    protected ApplicationConfiguration[] getRequestFieldValue() {
        return (ApplicationConfiguration[])this.request.getFieldValue();
    }

    protected ComponentSerializationStrategy getSerializationStrategy() {
        return this.request.getSerializationStrategy();
    }

    protected String getRequestApplicationName() {
        return this.request.getApplicationName();
    }

    @Override
    public void execute() throws FieldOperationException {
        try {
            this.beforeReplace();
            ApplicationConfiguration[] value = this.buildFieldValue();
            this.replace(value);
            this.afterReplace();
            this.getFieldExecutor().restartFieldIfNeeded();
        }
        catch (FieldExecutorException e) {
            throw new FieldOperationException(e.getMessage(), e);
        }
    }

    private void replace(Object value) throws FieldExecutorException {
        this.getFieldExecutor().setFieldValue(value);
    }

    protected abstract void beforeReplace() throws FieldExecutorException;

    protected abstract ApplicationConfiguration[] buildFieldValue() throws FieldExecutorException;

    protected void afterReplace() throws FieldExecutorException {
        ApplicationConfiguration[] configurations = this.getCurrentConfigurations();
        String requestAppName = this.getRequestApplicationName();
        for (ApplicationConfiguration configuration : configurations) {
            if (requestAppName != null && !requestAppName.equals(configuration.getApplicationName())) continue;
            ApplicationSerializationStrategy strategy = (ApplicationSerializationStrategy)this.request.getSerializationStrategy();
            ApplicationConfiguration[] configurationAsArray = new ApplicationConfiguration[]{configuration};
            strategy.replace(configuration.getApplicationName(), configurationAsArray);
        }
    }

    protected ApplicationConfiguration[] getCurrentConfigurations() throws FieldExecutorException {
        return (ApplicationConfiguration[])this.request.getFieldExecutor().getFieldValue();
    }

    protected ApplicationConfiguration[] getCurrentConfigurationsExcludingByTheApplicationNameInTheRequest() throws FieldExecutorException {
        ApplicationConfiguration[] currentConfigurations = this.getCurrentConfigurations();
        HashSet<ApplicationConfiguration> updatedConfigurations = new HashSet<ApplicationConfiguration>();
        if (currentConfigurations != null) {
            for (ApplicationConfiguration configuration : currentConfigurations) {
                if (this.getRequestApplicationName().equals(configuration.getApplicationName())) continue;
                updatedConfigurations.add(configuration);
            }
        }
        return (ApplicationConfiguration[])updatedConfigurations.stream().toArray(ApplicationConfiguration[]::new);
    }
}

