/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.operations;

import com.mulesoft.agent.exception.ComponentOperationException;
import com.mulesoft.agent.exception.InvalidFieldException;
import com.mulesoft.agent.services.administration.components.operations.ComponentOperation;
import com.mulesoft.agent.services.administration.components.operations.ComponentOperationRequest;
import com.mulesoft.agent.services.administration.components.operations.fields.ComponentFieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.ComponentFieldOperationRequest;
import com.mulesoft.agent.services.administration.components.operations.fields.FieldOperation;
import com.mulesoft.agent.services.administration.components.operations.fields.executors.ComponentFieldExecutor;
import com.mulesoft.agent.services.administration.components.serialization.ComponentSerializationStrategy;
import com.mulesoft.agent.services.administration.exception.FieldOperationException;
import com.mulesoft.agent.services.administration.wrappers.FieldWrapper;

public class DefaultComponentOperation
implements ComponentOperation {
    private ComponentOperationRequest request;
    private FieldOperation fieldOperation;

    public DefaultComponentOperation(ComponentOperationRequest request, FieldOperation fieldOperation) {
        this.request = request;
        this.fieldOperation = fieldOperation;
    }

    @Override
    public void execute() throws ComponentOperationException, NoSuchFieldException {
        for (String fieldName : this.request.getConfiguration().keySet()) {
            Object fieldValue = this.request.getConfiguration().get(fieldName);
            FieldWrapper field = this.request.getComponent().findField(fieldName);
            try {
                ComponentFieldExecutor fieldExecutor = this.request.getFieldExecutorBuilder().from(field).build();
                ComponentSerializationStrategy serializationStrategy = this.request.getSerializationStrategyBuilder().from(field).build();
                ComponentFieldOperationRequest fieldOperationRequest = new ComponentFieldOperationRequest(fieldExecutor, serializationStrategy, fieldValue, this.request.getApplicationName(), this.request.isRestartDisabled());
                ComponentFieldOperation componentFieldOperation = this.request.getFieldOperationBuilder().from(this.fieldOperation, field, fieldOperationRequest).build();
                componentFieldOperation.execute();
            }
            catch (FieldOperationException e) {
                throw new ComponentOperationException(e.getMessage(), (Throwable)e);
            }
            catch (InvalidFieldException invalidFieldException) {
            }
        }
    }
}

