/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components.operations;

import com.google.gson.Gson;
import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.services.administration.components.operations.fields.FieldOperationBuilder;
import com.mulesoft.agent.services.administration.components.operations.fields.executors.ComponentFieldExecutorBuilder;
import com.mulesoft.agent.services.administration.components.serialization.ComponentSerializationStrategyBuilder;
import com.mulesoft.agent.services.administration.wrappers.ComponentWrapper;
import java.util.HashMap;
import java.util.Map;

public class ComponentOperationRequest {
    private ComponentWrapper component;
    private MuleAgentDescriptor descriptor;
    private Gson gson;
    private Map<String, Object> configuration;
    private String applicationName;
    private ComponentFieldExecutorBuilder fieldExecutorBuilder;
    private ComponentSerializationStrategyBuilder serializationStrategyBuilder;
    private FieldOperationBuilder fieldOperationBuilder;
    private boolean restartDisabled;

    private ComponentOperationRequest(ComponentWrapper component, Map<String, Object> fromConfiguration, MuleAgentDescriptor descriptor, Gson gson, String applicationName, boolean restartDisabled) {
        this.component = component;
        this.descriptor = descriptor;
        this.gson = gson;
        this.configuration = fromConfiguration;
        this.applicationName = applicationName;
        this.fieldExecutorBuilder = ComponentFieldExecutorBuilder.create(component, descriptor, gson);
        this.serializationStrategyBuilder = ComponentSerializationStrategyBuilder.create(component, descriptor, gson);
        this.fieldOperationBuilder = FieldOperationBuilder.create();
        this.restartDisabled = restartDisabled;
    }

    private ComponentOperationRequest(ComponentWrapper component, MuleAgentDescriptor descriptor, Gson gson, String applicationName, boolean disableRestart) {
        this(component, new HashMap<String, Object>(), descriptor, gson, applicationName, disableRestart);
    }

    public ComponentOperationRequest(ComponentWrapper component, Map<String, Object> fromConfiguration, MuleAgentDescriptor descriptor, Gson gson) {
        this(component, fromConfiguration, descriptor, gson, null, false);
    }

    public ComponentOperationRequest(ComponentWrapper component, Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName, MuleAgentDescriptor descriptor, Gson gson, boolean disableRestart) {
        this(component, descriptor, gson, applicationName, disableRestart);
        this.configuration = this.mapFieldValueToObject(fromConfiguration);
    }

    public ComponentOperationRequest(ComponentWrapper component, Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName, MuleAgentDescriptor descriptor, Gson gson) {
        this(component, fromConfiguration, applicationName, descriptor, gson, false);
    }

    public ComponentWrapper getComponent() {
        return this.component;
    }

    public MuleAgentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Gson getGson() {
        return this.gson;
    }

    public Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    private Map<String, Object> mapFieldValueToObject(Map<String, ApplicationConfiguration[]> fromConfiguration) {
        HashMap<String, Object> mappedConfigurations = new HashMap<String, Object>();
        for (String fieldName : fromConfiguration.keySet()) {
            mappedConfigurations.put(fieldName, fromConfiguration.get(fieldName));
        }
        return mappedConfigurations;
    }

    public ComponentFieldExecutorBuilder getFieldExecutorBuilder() {
        return this.fieldExecutorBuilder;
    }

    public ComponentSerializationStrategyBuilder getSerializationStrategyBuilder() {
        return this.serializationStrategyBuilder;
    }

    public FieldOperationBuilder getFieldOperationBuilder() {
        return this.fieldOperationBuilder;
    }

    public boolean isRestartDisabled() {
        return this.restartDisabled;
    }
}

