/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components;

import com.google.gson.Gson;
import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.configuration.postconfigure.PostConfigureRunner;
import com.mulesoft.agent.services.Switcher;
import com.mulesoft.agent.services.administration.components.ComponentManager;
import com.mulesoft.agent.services.administration.components.ComponentManagerRequest;
import com.mulesoft.agent.services.administration.components.operations.ComponentOperation;
import com.mulesoft.agent.services.administration.components.operations.ComponentOperationRequest;
import com.mulesoft.agent.services.administration.components.operations.fields.FieldOperation;
import java.util.Map;

public class ComponentManagerBuilder {
    private ComponentManagerRequest componentRequest;
    private ComponentOperation componentOperation;
    private boolean disableRestartComponent = false;

    private ComponentManagerBuilder() {
    }

    private ComponentManagerBuilder(Switcher component, MuleAgentDescriptor descriptor, Gson gson, PostConfigureRunner postConfigureRunner) {
        this.componentRequest = new ComponentManagerRequest(component, descriptor, gson, postConfigureRunner);
    }

    public static ComponentManagerBuilder create() {
        return new ComponentManagerBuilder();
    }

    public ComponentManagerBuilder from(Switcher component, MuleAgentDescriptor descriptor, Gson gson, PostConfigureRunner postConfigureRunner) {
        return new ComponentManagerBuilder(component, descriptor, gson, postConfigureRunner);
    }

    public ComponentManagerBuilder disableRestart() {
        this.disableRestartComponent = true;
        return this;
    }

    public ComponentManagerBuilder buildChangeOperation(Map fromConfiguration) {
        return this.buildReplaceOperation(fromConfiguration);
    }

    public ComponentManagerBuilder buildChangeOperation(Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName) {
        return this.buildUpdateOperation(fromConfiguration, applicationName);
    }

    public ComponentManagerBuilder buildReplaceOperation(Map fromConfiguration) {
        ComponentOperationRequest request = this.buildOperationRequest(fromConfiguration);
        this.componentOperation = this.componentRequest.getOperationBuilder().from(FieldOperation.REPLACE, request).build();
        return this;
    }

    public ComponentManagerBuilder buildReplaceOperation(Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName) {
        ComponentOperationRequest request = this.buildOperationRequest(fromConfiguration, applicationName);
        this.componentOperation = this.componentRequest.getOperationBuilder().from(FieldOperation.REPLACE, request).build();
        return this;
    }

    public ComponentManagerBuilder buildUpdateOperation(Map fromConfiguration) {
        ComponentOperationRequest request = this.buildOperationRequest(fromConfiguration);
        this.componentOperation = this.componentRequest.getOperationBuilder().from(FieldOperation.UPDATE, request).build();
        return this;
    }

    public ComponentManagerBuilder buildUpdateOperation(Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName) {
        ComponentOperationRequest request = this.buildOperationRequest(fromConfiguration, applicationName);
        this.componentOperation = this.componentRequest.getOperationBuilder().from(FieldOperation.UPDATE, request).build();
        return this;
    }

    public ComponentManagerBuilder buildDeleteOperation(Map fromConfiguration) {
        ComponentOperationRequest request = this.buildOperationRequest(fromConfiguration);
        this.componentOperation = this.componentRequest.getOperationBuilder().from(FieldOperation.DELETE, request).build();
        return this;
    }

    private ComponentOperationRequest buildOperationRequest(Map fromConfiguration) {
        return new ComponentOperationRequest(this.componentRequest.getComponent(), fromConfiguration, this.componentRequest.getDescriptor(), this.componentRequest.getGson());
    }

    private ComponentOperationRequest buildOperationRequest(Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName) {
        return new ComponentOperationRequest(this.componentRequest.getComponent(), fromConfiguration, applicationName, this.componentRequest.getDescriptor(), this.componentRequest.getGson(), this.disableRestartComponent);
    }

    public ComponentManager build() {
        return new ComponentManager(this.componentRequest, this.componentOperation, this.disableRestartComponent);
    }

    ComponentManagerRequest getComponentRequest() {
        return this.componentRequest;
    }

    ComponentOperation getComponentOperation() {
        return this.componentOperation;
    }

    boolean isDisableRestartComponent() {
        return this.disableRestartComponent;
    }
}

