/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration.components;

import com.mulesoft.agent.configuration.postconfigure.PostConfigureInfo;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ComponentOperationException;
import com.mulesoft.agent.services.administration.components.ComponentManagerRequest;
import com.mulesoft.agent.services.administration.components.operations.ComponentOperation;
import com.mulesoft.agent.services.administration.wrappers.ComponentWrapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ComponentManager {
    private static final Logger LOGGER = LogManager.getLogger(ComponentManager.class);
    private ComponentManagerRequest componentRequest;
    private ComponentOperation componentOperation;
    private boolean disableRestartComponent;

    protected ComponentManager(ComponentManagerRequest componentRequest, ComponentOperation componentOperation, boolean disableRestartComponent) {
        this.componentRequest = componentRequest;
        this.componentOperation = componentOperation;
        this.disableRestartComponent = disableRestartComponent;
    }

    public void execute() throws AgentEnableOperationException, ComponentOperationException, NoSuchFieldException {
        boolean initialState = this.componentRequest.getComponent().isEnabled();
        this.disableComponentIfNeeded(this.componentRequest.getComponent());
        this.componentOperation.execute();
        this.enableComponentIfNeeded(this.componentRequest.getComponent(), initialState);
    }

    void disableComponentIfNeeded(ComponentWrapper component) throws AgentEnableOperationException {
        if (!component.isEnabled()) {
            return;
        }
        if (!component.isRestartable()) {
            return;
        }
        LOGGER.debug("Your component must be disabled in order to change its configuration, disabling component: {}", (Object)component.getComponentId());
        component.enable(false);
    }

    void enableComponentIfNeeded(ComponentWrapper component, boolean wasEnabled) throws AgentEnableOperationException {
        if (!wasEnabled) {
            return;
        }
        if (component.isRestartable()) {
            LOGGER.info("Re-enabling component: {}", (Object)component.getComponentId());
            component.enable(true);
        }
        this.runComponentPostConfiguration(component);
    }

    private void runComponentPostConfiguration(ComponentWrapper component) {
        LOGGER.debug("Running post configurations for the component: {} ", (Object)component.getComponentId());
        PostConfigureInfo postConfigureInfo = new PostConfigureInfo(component.getComponentId(), (Object)component.toSwitcher(), component.toSwitcher().getClass());
        this.componentRequest.getPostConfigureRunner().run(postConfigureInfo);
    }

    protected ComponentManagerRequest getComponentRequest() {
        return this.componentRequest;
    }

    protected ComponentOperation getComponentOperation() {
        return this.componentOperation;
    }

    protected boolean isDisableRestartComponent() {
        return this.disableRestartComponent;
    }
}

