/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.administration;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.inject.Injector;
import com.google.inject.TypeLiteral;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.configuration.ApplicationConfiguration;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.DefaultRuntimeEnvironmentProvider;
import com.mulesoft.agent.configuration.Password;
import com.mulesoft.agent.configuration.ReportConfiguration;
import com.mulesoft.agent.configuration.common.AuthProxyClientProvider;
import com.mulesoft.agent.configuration.descriptor.MuleAgentDescriptor;
import com.mulesoft.agent.configuration.encryption.EncryptionServiceBuilder;
import com.mulesoft.agent.configuration.postconfigure.PostConfigureInfo;
import com.mulesoft.agent.configuration.postconfigure.PostConfigureRunner;
import com.mulesoft.agent.details.utils.DefaultCertificateDetails;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.domain.administration.AddressInfo;
import com.mulesoft.agent.domain.administration.ConfigurableField;
import com.mulesoft.agent.domain.administration.ServerType;
import com.mulesoft.agent.domain.certificates.CertificateRenewalRequest;
import com.mulesoft.agent.domain.scheduler.Scheduler;
import com.mulesoft.agent.domain.switcher.Component;
import com.mulesoft.agent.domain.switcher.ConfigurationNotification;
import com.mulesoft.agent.exception.AgentCertificateException;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.AgentEncryptionException;
import com.mulesoft.agent.exception.ComponentOperationException;
import com.mulesoft.agent.exception.InvalidConfigurationException;
import com.mulesoft.agent.exception.InvalidFieldException;
import com.mulesoft.agent.exception.RuntimeRestartException;
import com.mulesoft.agent.exception.RuntimeShutdownException;
import com.mulesoft.agent.handlers.ExternalMessageHandler;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.jackson.SchedulerDeserializerSerializer;
import com.mulesoft.agent.security.FipsUtils;
import com.mulesoft.agent.services.AdministrationService;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.services.LicenseService;
import com.mulesoft.agent.services.MuleAgentService;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.agent.services.Switcher;
import com.mulesoft.agent.services.administration.components.ComponentManager;
import com.mulesoft.agent.services.administration.components.ComponentManagerBuilder;
import com.mulesoft.agent.services.administration.wrappers.ApplicationConfigurationWrapper;
import com.mulesoft.agent.services.administration.wrappers.ComponentWrapper;
import com.mulesoft.agent.services.administration.wrappers.FieldWrapper;
import com.mulesoft.agent.util.DefaultLicenseService;
import com.mulesoft.agent.util.ReflectionUtils;
import com.mulesoft.agent.util.service.AgentCertificateManagerService;
import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManager;
import com.mulesoft.mule.runtime.module.plugin.api.management.MuleInstanceManagerAware;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.URL;
import java.security.Key;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.Response;
import org.mule.runtime.api.lifecycle.Initialisable;

@Named(value="mule.agent.switcher.service")
@Singleton
public class MuleAgentAdministrationService
implements AdministrationService,
MuleInstanceManagerAware,
Initialisable {
    private static final Logger LOGGER = LogManager.getLogger(MuleAgentAdministrationService.class);
    private static final String CONFIGURATION_FOLDER_PROPERTY = "mule.agent.configuration.folder";
    private static final String ENVIRONMENT_KEY = "environment";
    private static final String TRANSPORTS_KEY = "transports";
    private static final int SHUTDOWN_EXIT_CODE = 0;
    private AtomicBoolean muleStarted = new AtomicBoolean(false);
    private DefaultCertificateDetails certDetails = new DefaultCertificateDetails(FipsUtils.getKeystoreType());
    MuleInstanceManager muleInstanceManager;
    Map<String, MuleAgentService> services;
    Map<String, InternalMessageHandler> internalHandlers;
    Map<String, ExternalMessageHandler> externalHandlers;
    PostConfigureRunner postConfigureRunner;
    MuleAgentDescriptor muleAgentDescriptor;
    RuntimeVersionService runtimeVersionService;
    AgentCertificateManagerService agentCertificateManagerService;
    AuthProxyClientProvider authProxyClientProvider;
    Set<InternalMessageHandler<ConfigurationNotification>> configurationNotificationHandlers;
    String environment;
    RuntimeEnvironment[] runtimeEnvironments;
    ComponentManagerBuilder componentManagerBuilder = ComponentManagerBuilder.create();
    @Inject
    private Injector injector;
    Gson gson;
    private LicenseService muleLicenseUtils = new DefaultLicenseService();
    private EncryptionService encryptorService = EncryptionServiceBuilder.newInstance().build();

    public MuleAgentAdministrationService() {
        this.gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Scheduler.class, (Object)new SchedulerDeserializerSerializer()).create();
    }

    public void initialise() {
        this.services = (Map)this.injector.getInstance(com.google.inject.Key.get((TypeLiteral)new TypeLiteral<Map<String, MuleAgentService>>(){}));
        this.agentCertificateManagerService = (AgentCertificateManagerService)this.injector.getInstance(AgentCertificateManagerService.class);
        this.internalHandlers = (Map)this.injector.getInstance(com.google.inject.Key.get((TypeLiteral)new TypeLiteral<Map<String, InternalMessageHandler>>(){}));
        this.externalHandlers = (Map)this.injector.getInstance(com.google.inject.Key.get((TypeLiteral)new TypeLiteral<Map<String, ExternalMessageHandler>>(){}));
        this.postConfigureRunner = (PostConfigureRunner)this.injector.getInstance(PostConfigureRunner.class);
        this.muleAgentDescriptor = (MuleAgentDescriptor)this.injector.getInstance(MuleAgentDescriptor.class);
        this.runtimeVersionService = (RuntimeVersionService)this.injector.getInstance(RuntimeVersionService.class);
        this.agentCertificateManagerService = (AgentCertificateManagerService)this.injector.getInstance(AgentCertificateManagerService.class);
        this.authProxyClientProvider = (AuthProxyClientProvider)this.injector.getInstance(AuthProxyClientProvider.class);
        this.configurationNotificationHandlers = (Set)this.injector.getInstance(com.google.inject.Key.get((TypeLiteral)new TypeLiteral<Set<InternalMessageHandler<ConfigurationNotification>>>(){}));
        this.initialiseRuntimeEnvironments();
    }

    public void initialiseRuntimeEnvironments() {
        Map configuration = this.muleAgentDescriptor.load();
        this.environment = (String)configuration.get(ENVIRONMENT_KEY);
        Map transportConfiguration = this.getDescriptorConfiguration(configuration, TRANSPORTS_KEY);
        DefaultRuntimeEnvironmentProvider runtimeProvider = new DefaultRuntimeEnvironmentProvider(transportConfiguration, this.environment);
        this.runtimeEnvironments = runtimeProvider.getRuntimeEnvironment();
    }

    public void setMuleInstanceManager(MuleInstanceManager muleInstanceManager) {
        this.muleInstanceManager = muleInstanceManager;
    }

    public List<Component> getServiceStatus() {
        LinkedList<Component> serviceStatus = new LinkedList<Component>();
        for (Map.Entry<String, MuleAgentService> service : this.services.entrySet()) {
            serviceStatus.add(new Component(service.getKey(), service.getValue().isEnabled()));
        }
        return serviceStatus;
    }

    public List<Component> getInternalHandlerStatus() {
        LinkedList<Component> internalHandlerStatus = new LinkedList<Component>();
        for (Map.Entry<String, InternalMessageHandler> internalHandler : this.internalHandlers.entrySet()) {
            internalHandlerStatus.add(new Component(internalHandler.getKey(), internalHandler.getValue().isEnabled()));
        }
        return internalHandlerStatus;
    }

    public List<Component> getExternalHandlerStatus() {
        LinkedList<Component> externalHandlerStatus = new LinkedList<Component>();
        for (Map.Entry<String, ExternalMessageHandler> externalHandler : this.externalHandlers.entrySet()) {
            externalHandlerStatus.add(new Component(externalHandler.getKey(), externalHandler.getValue().isEnabled()));
        }
        return externalHandlerStatus;
    }

    public Map<String, Object> getConfiguration() {
        HashMap<String, Object> configuration = new HashMap<String, Object>();
        for (String service : this.services.keySet()) {
            configuration.put(service, this.getServiceConfiguration(service));
        }
        for (String internalHandler : this.internalHandlers.keySet()) {
            configuration.put(internalHandler, this.getInternalHandlerConfiguration(internalHandler));
        }
        for (String externalHandler : this.externalHandlers.keySet()) {
            configuration.put(externalHandler, this.getExternalHandlerConfiguration(externalHandler));
        }
        return configuration;
    }

    public void switchComponent(String componentId, boolean enable) throws AgentEnableOperationException, NoSuchElementException {
        Switcher component = this.findComponent(componentId);
        component.enable(enable);
        PostConfigureInfo postConfigureInfo = new PostConfigureInfo(componentId, (Object)component, component.getClass());
        this.postConfigureRunner.run(postConfigureInfo);
        Field field = ReflectionUtils.findField(component.getClass(), (String)"enabled");
        field.setAccessible(true);
        try {
            field.set(component, enable);
        }
        catch (IllegalAccessException e) {
            LOGGER.warn("Unable to switch enable/disable for component: {}", (Object)componentId);
            LOGGER.debug((Object)e);
        }
        this.muleAgentDescriptor.setFieldValue(component.getClass(), field, (Object)enable);
    }

    public void changeConfiguration(String componentId, Map fromConfiguration) throws AgentEnableOperationException, ComponentOperationException, NoSuchFieldException {
        Switcher component = this.findComponent(componentId);
        ComponentManager componentManager = this.componentManagerBuilder.from(component, this.muleAgentDescriptor, this.gson, this.postConfigureRunner).buildChangeOperation(fromConfiguration).build();
        componentManager.execute();
        this.reportCurrentConfiguration(componentId, component);
    }

    public void updateConfiguration(String componentId, Map fromConfiguration) throws AgentEnableOperationException, ComponentOperationException, NoSuchFieldException {
        Switcher component = this.findComponent(componentId);
        ComponentManager componentManager = this.componentManagerBuilder.from(component, this.muleAgentDescriptor, this.gson, this.postConfigureRunner).buildUpdateOperation(fromConfiguration).build();
        componentManager.execute();
        this.reportCurrentConfiguration(componentId, component);
    }

    public void deleteConfiguration(String componentId, Map fromConfiguration) throws AgentEnableOperationException, ComponentOperationException, NoSuchFieldException {
        Switcher component = this.findComponent(componentId);
        ComponentManager componentManager = this.componentManagerBuilder.from(component, this.muleAgentDescriptor, this.gson, this.postConfigureRunner).buildDeleteOperation(fromConfiguration).build();
        componentManager.execute();
        this.reportCurrentConfiguration(componentId, component);
    }

    public void changeConfiguration(String componentId, Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName) throws AgentEnableOperationException, ComponentOperationException, NoSuchFieldException {
        Switcher component = this.findComponent(componentId);
        fromConfiguration.entrySet().stream().forEach(e -> ApplicationConfigurationWrapper.create((ApplicationConfiguration[])e.getValue(), applicationName).validate());
        ComponentManager componentManager = this.componentManagerBuilder.from(component, this.muleAgentDescriptor, this.gson, this.postConfigureRunner).buildChangeOperation(fromConfiguration, applicationName).build();
        componentManager.execute();
        this.reportCurrentConfiguration(componentId, component);
    }

    public void updateApplicationConfiguration(String componentId, ApplicationConfiguration fromConfiguration, String applicationName) throws NoSuchElementException, NoSuchFieldException, ComponentOperationException, AgentEnableOperationException {
        Switcher component = this.findComponent(componentId);
        Field field = ComponentWrapper.create(component).findApplicationConfigurationField();
        ApplicationConfiguration[] valueAsArray = new ApplicationConfiguration[]{fromConfiguration};
        this.updateApplicationConfiguration(componentId, field.getName(), valueAsArray, applicationName);
    }

    public void updateApplicationConfiguration(String componentId, String fieldName, ApplicationConfiguration fromConfiguration, String applicationName) throws ComponentOperationException, NoSuchFieldException, AgentEnableOperationException {
        ApplicationConfiguration[] valueAsArray = new ApplicationConfiguration[]{fromConfiguration};
        this.updateApplicationConfiguration(componentId, fieldName, valueAsArray, applicationName);
    }

    public void updateApplicationConfiguration(String componentId, String fieldName, ApplicationConfiguration[] fromConfiguration, String applicationName) throws ComponentOperationException, NoSuchFieldException, IllegalArgumentException, AgentEnableOperationException {
        Switcher component = this.findComponent(componentId);
        ApplicationConfigurationWrapper.create(fromConfiguration, applicationName).validate();
        Map<String, ApplicationConfiguration[]> componentConfiguration = Collections.singletonMap(fieldName, fromConfiguration);
        ComponentManager componentManager = this.componentManagerBuilder.from(component, this.muleAgentDescriptor, this.gson, this.postConfigureRunner).disableRestart().buildUpdateOperation(componentConfiguration, applicationName).build();
        componentManager.execute();
    }

    public Map<String, Map<String, List<Map>>> loadApplicationConfigurationsFromDescriptor(String applicationName) throws AgentEnableOperationException, IllegalClassFormatException, InvocationTargetException {
        Map fragment = this.muleAgentDescriptor.loadFromFragment(applicationName);
        if (fragment == null) {
            return null;
        }
        return (Map)fragment.get("services");
    }

    public void replaceConfiguration(String componentId, Map<String, Object> fromConfiguration) throws AgentEnableOperationException, ComponentOperationException, NoSuchFieldException, InvalidFieldException {
        Switcher component = this.findComponent(componentId);
        ComponentManager componentManager = this.componentManagerBuilder.from(component, this.muleAgentDescriptor, this.gson, this.postConfigureRunner).buildReplaceOperation(fromConfiguration).build();
        componentManager.execute();
        this.reportCurrentConfiguration(componentId, component);
    }

    public void replaceConfiguration(String componentId, Map<String, ApplicationConfiguration[]> fromConfiguration, String applicationName) throws AgentEnableOperationException, ComponentOperationException, NoSuchFieldException {
        Switcher component = this.findComponent(componentId);
        ComponentManager componentManager = this.componentManagerBuilder.from(component, this.muleAgentDescriptor, this.gson, this.postConfigureRunner).buildReplaceOperation(fromConfiguration, applicationName).build();
        componentManager.execute();
        this.reportCurrentConfiguration(componentId, component);
    }

    public void removeApplicationConfiguration(String applicationName) throws IllegalAccessException {
        this.muleAgentDescriptor.removeApplicationConfigurationFile(applicationName);
    }

    public Map<String, Object> getConfiguration(String componentId) throws IllegalStateException, NoSuchElementException {
        Map<String, Object> configuration = this.getServiceConfiguration(componentId);
        if (configuration != null) {
            return configuration;
        }
        configuration = this.getInternalHandlerConfiguration(componentId);
        if (configuration != null) {
            return configuration;
        }
        configuration = this.getExternalHandlerConfiguration(componentId);
        if (configuration != null) {
            return configuration;
        }
        throw new NoSuchElementException(String.format("Component %s does not exist.", componentId));
    }

    public List<AddressInfo> listAddresses() {
        Enumeration<NetworkInterface> interfaces;
        LinkedList<AddressInfo> addresses = new LinkedList<AddressInfo>();
        try {
            interfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            LOGGER.error("An error occurred while reading the network interfaces: {}", (Object)e.getMessage());
            LOGGER.debug((Object)e);
            return addresses;
        }
        while (interfaces.hasMoreElements()) {
            NetworkInterface inet = interfaces.nextElement();
            Enumeration<InetAddress> inetIps = inet.getInetAddresses();
            while (inetIps.hasMoreElements()) {
                InetAddress i = inetIps.nextElement();
                AddressInfo addressInfo = new AddressInfo();
                addressInfo.setIp(i.getHostAddress());
                addressInfo.setNetworkInterface(inet.getName());
                addresses.add(addressInfo);
            }
        }
        return addresses;
    }

    public void setMuleStarted(boolean isStarted) {
        this.muleStarted.set(isStarted);
    }

    public boolean isMuleStarted() {
        return this.muleStarted.get();
    }

    public String getMuleVersion() {
        return this.runtimeVersionService.getRuntimeVersion();
    }

    @Deprecated
    public String getGatewayVersion() {
        return this.runtimeVersionService.getGatewayVersion();
    }

    public ServerType getServerType() {
        if (this.runtimeVersionService.isGateway()) {
            return ServerType.GATEWAY;
        }
        return ServerType.MULE;
    }

    public String getMuleLicenseExpirationDate() {
        Date expirationDate = this.muleLicenseUtils.getExpirationDate();
        if (expirationDate != null) {
            return Long.toString(expirationDate.getTime());
        }
        return "";
    }

    public String getMuleServerId() {
        return this.certDetails.getServerId();
    }

    public String getMuleContextId() {
        return this.certDetails.getContextId();
    }

    public Certificate[] getMuleCertChain() {
        return this.certDetails.getCertChain();
    }

    public Key getMulePrivateKey() {
        return this.certDetails.getPrivateKey();
    }

    public String getAgentVersion() {
        String className;
        Class<?> clazz = this.getClass();
        String classPath = clazz.getResource(className = clazz.getSimpleName() + ".class").toString();
        if (!classPath.startsWith("jar")) {
            return "";
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf("!") + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            return attr.getValue("Specification-Version");
        }
        catch (IOException e) {
            return "";
        }
    }

    public Map<String, String> getOSInformation() {
        HashMap<String, String> osInfo = new HashMap<String, String>();
        osInfo.put("name", SystemUtils.OS_NAME);
        osInfo.put("architecture", SystemUtils.OS_ARCH);
        osInfo.put("version", SystemUtils.OS_VERSION);
        return osInfo;
    }

    public Map<String, Map<String, String>> getJavaInformation() {
        HashMap<String, Map<String, String>> javaInfo = new HashMap<String, Map<String, String>>();
        HashMap<String, String> runtime = new HashMap<String, String>();
        runtime.put("name", SystemUtils.JAVA_RUNTIME_NAME);
        runtime.put("version", SystemUtils.JAVA_RUNTIME_VERSION);
        javaInfo.put("runtime", runtime);
        HashMap<String, String> specification = new HashMap<String, String>();
        specification.put("name", SystemUtils.JAVA_SPECIFICATION_NAME);
        specification.put("vendor", SystemUtils.JAVA_VM_VENDOR);
        specification.put("version", SystemUtils.JAVA_SPECIFICATION_VERSION);
        javaInfo.put("specification", specification);
        return javaInfo;
    }

    public boolean isPortAvailable(int port) {
        try {
            ServerSocket socket = new ServerSocket(port);
            socket.close();
            return true;
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
            return false;
        }
    }

    public void shutdownRuntime() throws RuntimeShutdownException {
        try {
            this.muleInstanceManager.stop(0);
        }
        catch (Exception ex) {
            throw new RuntimeShutdownException((Throwable)ex);
        }
    }

    public void restartRuntime() throws RuntimeRestartException {
        try {
            this.muleInstanceManager.restart();
        }
        catch (Exception ex) {
            throw new RuntimeRestartException((Throwable)ex);
        }
    }

    public void renewAgentCertificate() throws AgentCertificateException {
        try {
            LOGGER.debug("Renew certificate - starting");
            String confFolder = System.getProperty(CONFIGURATION_FOLDER_PROPERTY);
            LOGGER.debug("Renew certificate - opening conf folder: {}", (Object)confFolder);
            File confFolderFile = new File(confFolder);
            LOGGER.debug("Renew certificate - generating keypair");
            KeyPair keyPair = this.agentCertificateManagerService.generateKeyPair();
            LOGGER.debug("Renew certificate - generating certificate request");
            CertificateRenewalRequest certificateRenewalRequest = this.agentCertificateManagerService.getRenewAgentCertificateRequest(keyPair);
            LOGGER.debug("Renew certificate - requesting certification renewal to AuthProxy");
            AuthenticationProxyClient authenticationProxyClient = this.authProxyClientProvider.getClient(confFolder);
            Response response = authenticationProxyClient.put("/mule/servers", (Object)certificateRenewalRequest);
            LOGGER.debug("Renew certificate - AuthProxy response: {}", (Object)response.getStatusCode());
            LOGGER.debug("Renew certificate - creating certificate backup");
            this.agentCertificateManagerService.backupJKS(confFolderFile);
            LOGGER.debug("Renew certificate - generating certificate");
            this.agentCertificateManagerService.generateJKS(confFolderFile, response.getResponseBodyAsStream(), keyPair);
            LOGGER.debug("Renew certificate - success");
        }
        catch (Throwable e) {
            LOGGER.error("Unable to renew the agent certificate.", e);
            throw new AgentCertificateException(e);
        }
    }

    private void reportCurrentConfiguration(String componentId, Switcher component) {
        if (component instanceof ReportConfiguration) {
            ConfigurationNotification notification = new ConfigurationNotification(componentId, component.isEnabled(), this.getComponentConfiguration(component));
            for (InternalMessageHandler<ConfigurationNotification> handler : this.configurationNotificationHandlers) {
                try {
                    handler.handle((Object)notification);
                }
                catch (Exception e) {
                    LOGGER.warn("Unable to report the current configuration for component {}.", (Object)componentId, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                    LOGGER.debug((Object)e);
                }
            }
        }
    }

    private Map<String, Object> getServiceConfiguration(String componentId) {
        if (this.services.containsKey(componentId)) {
            MuleAgentService service = this.services.get(componentId);
            Map<String, Object> serviceConfiguration = this.getComponentConfiguration(service);
            ArrayList<InjectedHandler> injectedHandlers = new ArrayList<InjectedHandler>();
            for (InternalMessageHandler internalHandler : service.getInternalHandlers()) {
                String path = "/mule/agent/" + internalHandler.getClass().getAnnotation(Named.class).value() + "/configuration";
                Type internalHandlerInterface = null;
                LinkedList classHierarchy = new LinkedList();
                Class<?> subclass = internalHandler.getClass();
                Class<?> superclass = subclass.getSuperclass();
                while (subclass != null) {
                    for (Type interfaze : Arrays.asList(subclass.getGenericInterfaces())) {
                        if (!(interfaze instanceof ParameterizedType) || !InternalMessageHandler.class.isAssignableFrom((Class)((ParameterizedType)interfaze).getRawType())) continue;
                        internalHandlerInterface = interfaze;
                    }
                    if (internalHandlerInterface != null) break;
                    classHierarchy.offer(subclass);
                    subclass = superclass;
                    superclass = subclass.getSuperclass();
                }
                Type internalHandlerType = ((ParameterizedType)internalHandlerInterface).getActualTypeArguments()[0];
                Class implementerClass = (Class)classHierarchy.poll();
                while (internalHandlerType instanceof TypeVariable) {
                    internalHandlerType = ((ParameterizedType)implementerClass.getGenericSuperclass()).getActualTypeArguments()[0];
                    implementerClass = (Class)classHierarchy.poll();
                }
                injectedHandlers.add(new InjectedHandler(internalHandler.getClass().getName(), path, internalHandlerType.toString()));
            }
            serviceConfiguration.put("serviceHandlerTypes", this.getServiceHandlerTypes(service));
            serviceConfiguration.put("injectedHandlers", injectedHandlers);
            return serviceConfiguration;
        }
        return null;
    }

    private Map<String, Object> getInternalHandlerConfiguration(String componentId) {
        if (this.internalHandlers.containsKey(componentId)) {
            return this.getComponentConfiguration(this.internalHandlers.get(componentId));
        }
        return null;
    }

    private Map<String, Object> getExternalHandlerConfiguration(String componentId) {
        if (this.externalHandlers.containsKey(componentId)) {
            return this.getComponentConfiguration(this.externalHandlers.get(componentId));
        }
        return null;
    }

    private Map<String, Object> getComponentConfiguration(Object component) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList configurableFields = new ArrayList();
        ReflectionUtils.doWithFields(component.getClass(), field -> {
            boolean isPassword;
            Configurable annotation = field.getAnnotation(Configurable.class);
            boolean bl = isPassword = field.getAnnotation(Password.class) != null;
            if (annotation != null && !isPassword) {
                field.setAccessible(true);
                try {
                    Object fieldValue = field.get(component);
                    ConfigurableField configurableField = new ConfigurableField(field.getName(), field.getType(), fieldValue, annotation.type(), annotation.description());
                    boolean found = false;
                    for (ConfigurableField existingField : configurableFields) {
                        if (!existingField.getName().equals(configurableField.getName())) continue;
                        found = true;
                    }
                    if (!found) {
                        configurableFields.add(configurableField);
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        });
        properties.put("configurableFields", configurableFields);
        return properties;
    }

    private List<String> getServiceHandlerTypes(MuleAgentService service) {
        ArrayList<String> serviceHandlerTypes = new ArrayList<String>();
        ReflectionUtils.doWithFields(service.getClass(), field -> {
            Type genericFieldType;
            Inject annotation = field.getAnnotation(Inject.class);
            if (annotation != null && (genericFieldType = field.getGenericType()) instanceof ParameterizedType) {
                Type[] fieldArgTypes;
                ParameterizedType aType = (ParameterizedType)genericFieldType;
                for (Type fieldArgType : fieldArgTypes = aType.getActualTypeArguments()) {
                    if (!(fieldArgType instanceof ParameterizedType) || !((ParameterizedType)fieldArgType).getRawType().equals(InternalMessageHandler.class)) continue;
                    serviceHandlerTypes.add(((ParameterizedType)fieldArgType).getActualTypeArguments()[0].toString());
                }
            }
        });
        return serviceHandlerTypes;
    }

    public Switcher findComponent(String componentId) throws NoSuchElementException {
        Switcher component = (Switcher)this.services.get(componentId);
        component = component == null ? (Switcher)this.internalHandlers.get(componentId) : component;
        Switcher switcher = component = component == null ? (Switcher)this.externalHandlers.get(componentId) : component;
        if (component == null) {
            throw new NoSuchElementException("Component " + componentId + " does not exist");
        }
        return component;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public RuntimeEnvironment[] getRuntimeEnvironments() {
        return this.runtimeEnvironments;
    }

    private Map getDescriptorConfiguration(Map configuration, String service) {
        Map map = (Map)configuration.get(this.services);
        if (map == null) {
            return new HashMap();
        }
        return map;
    }

    public char[] decrypt(String value) throws AgentEncryptionException {
        return this.encryptorService.decrypt(value).toCharArray();
    }

    public ApplicationConfiguration parseApplicationConfiguration(String componentId, Map<String, Object> fromConfiguration) throws NoSuchElementException, NoSuchFieldException, InvalidConfigurationException {
        Switcher component = this.findComponent(componentId);
        Field fieldInComponent = ComponentWrapper.create(component).findApplicationConfigurationField();
        for (String fieldName : fromConfiguration.keySet()) {
            try {
                Field fieldInConfiguration = fieldInComponent.getType().getComponentType().getDeclaredField(fieldName);
                String fieldValueInConfigurationAsString = this.gson.toJson(fromConfiguration.get(fieldName));
                Object object = this.gson.fromJson(fieldValueInConfigurationAsString, fieldInConfiguration.getType());
            }
            catch (NoSuchFieldException e) {
                throw new InvalidConfigurationException(String.format("Invalid configuration for component '%s': reference '%s' does not exist", componentId, fieldName));
            }
            catch (JsonSyntaxException e) {
                throw new InvalidConfigurationException(String.format("Invalid configuration for component '%s': reference '%s' has an invalid value. Reason: %s", componentId, fieldName, e.getMessage()));
            }
        }
        String configurationAsString = this.gson.toJson(fromConfiguration);
        Object applicationConfiguration = this.gson.fromJson(configurationAsString, fieldInComponent.getType().getComponentType());
        return (ApplicationConfiguration)applicationConfiguration;
    }

    public Object parseComponentConfiguration(String componentId, String fieldName, Object fromConfiguration) throws NoSuchElementException, NoSuchFieldException {
        Field fieldInComponent = this.findDynamicConfigurationFieldInComponent(componentId, fieldName);
        String configurationAsString = fromConfiguration instanceof String ? (String)fromConfiguration : this.gson.toJson(fromConfiguration);
        Object componentConfiguration = fieldInComponent.getType() == String.class ? configurationAsString : this.gson.fromJson(configurationAsString, fieldInComponent.getType());
        if (componentConfiguration == null) {
            throw new IllegalArgumentException(String.format("Unable to get field %s", fieldInComponent));
        }
        return componentConfiguration;
    }

    public ApplicationConfiguration[] parseApplicationConfiguration(String componentId, String fieldName, Object fromConfiguration) throws NoSuchFieldException {
        this.findApplicationConfigurationFieldInComponent(componentId, fieldName);
        Object parsedConfigurationAsObject = this.parseComponentConfiguration(componentId, fieldName, fromConfiguration);
        return (ApplicationConfiguration[])parsedConfigurationAsObject;
    }

    private Field findFieldInComponent(String componentId, String fieldName) throws NoSuchElementException, NoSuchFieldException {
        Field fieldInComponent;
        Switcher component = this.findComponent(componentId);
        try {
            fieldInComponent = ComponentWrapper.create(component).findField(fieldName).toField();
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldException(String.format("'%s' does not exist in component '%s'", fieldName, componentId));
        }
        return fieldInComponent;
    }

    private Field findApplicationConfigurationFieldInComponent(String componentId, String fieldName) throws NoSuchFieldException, NoSuchElementException {
        Field fieldInComponent = this.findFieldInComponent(componentId, fieldName);
        boolean isApplicationConfigurationField = FieldWrapper.create(fieldInComponent).isDynamicApplicationConfiguration();
        if (!isApplicationConfigurationField) {
            throw new NoSuchFieldException(String.format("'%s' does not allow dynamic application configurations in component '%s'", fieldName, componentId));
        }
        return fieldInComponent;
    }

    private Field findDynamicConfigurationFieldInComponent(String componentId, String fieldName) throws NoSuchElementException, NoSuchFieldException {
        Field fieldInComponent = this.findFieldInComponent(componentId, fieldName);
        boolean isDynamicConfigurationField = FieldWrapper.create(fieldInComponent).isDynamicConfiguration();
        if (!isDynamicConfigurationField) {
            throw new NoSuchFieldException(String.format("'%s' does not allow dynamic configuration for component '%s'", fieldName, componentId));
        }
        return fieldInComponent;
    }

    private class InjectedHandler {
        private String name;
        private String path;
        private String type;

        public InjectedHandler(String name, String path, String type) {
            this.name = name;
            this.path = path;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

