/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.service;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.ubp.meter.api.sampler.PricingSamplerTask;
import org.mule.ubp.meter.api.sampler.PricingSamplerTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerPricingMetricsSamplerTaskManager
implements PricingSamplerTaskManager {
    public static final String SAMPLER_SUFFIX = "-sampler";
    private static final String ERROR_SAMPLING_INSTRUMENTS = "Error while trying to sample instruments.";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerPricingMetricsSamplerTaskManager.class);
    final Map<String, PricingSamplerTask> pricingSamplers = new ConcurrentHashMap<String, PricingSamplerTask>();
    private final Scheduler scheduler;
    private final TimeUnit timeUnit;
    private final Long interval;

    public SchedulerPricingMetricsSamplerTaskManager(SchedulerService schedulerService, String name, Long interval, TimeUnit timeUnit) {
        this.interval = interval;
        this.timeUnit = timeUnit;
        this.scheduler = schedulerService.customScheduler(SchedulerConfig.config().withMaxConcurrentTasks(1).withWaitAllowed(true).withName(name + SAMPLER_SUFFIX), 10000);
    }

    public void addPricingSampler(String name, PricingSamplerTask pricingSamplerTask) {
        this.pricingSamplers.put(name, pricingSamplerTask);
    }

    public void removePricingSamplerFor(String artifactName) {
        this.pricingSamplers.remove(artifactName);
    }

    public void startSampling() {
        this.scheduler.scheduleAtFixedRate(this::sampleAll, 0L, this.interval.longValue(), this.timeUnit);
    }

    void sampleAll() {
        try {
            LOGGER.debug("Sampling task started.");
            this.pricingSamplers.values().forEach(PricingSamplerTask::sample);
        }
        catch (Exception e) {
            LOGGER.error(ERROR_SAMPLING_INSTRUMENTS, (Throwable)e);
        }
    }

    public void stopSampling() {
        this.scheduler.shutdown();
    }
}

