/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.ubp.plugin.deployment.listener;

import com.mulesoft.agent.ubp.plugin.exception.UpbMetricsException;
import com.mulesoft.agent.ubp.plugin.service.SchedulerPricingMetricsSamplerTaskManager;
import com.mulesoft.agent.ubp.plugin.stats.retriever.AllStatisticsRetriever;
import com.mulesoft.agent.ubp.plugin.stats.retriever.DefaultAllStatisticsRetriever;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.collector.PricingStatsCollector;
import org.mule.ubp.meter.api.sampler.PricingSamplerTaskManager;
import org.mule.ubp.meter.commons.pricing.PricingCollectorProvider;

public abstract class UbpMetricsDeploymentListener
implements DeploymentListener {
    public static final String METRICS_SCHEDULER_THREAD_NAME = "metrics-sampler";
    private final DeploymentService runtimeDeploymentService;
    private final AllStatisticsRetriever allStatisticsRetriever;
    private final PricingCollectorProvider pricingStatsCollectorProvider;
    private final Map<String, Object> globalConfiguration;
    private final SchedulerPricingMetricsSamplerTaskManager pricingSamplerManager;

    public UbpMetricsDeploymentListener(DeploymentService runtimeDeploymentService, SchedulerService schedulerService, AllStatisticsRetriever allStatisticsRetriever, PricingCollectorProvider pricingStatsCollectorProvider, Map<String, Object> globalConfiguration) {
        this(runtimeDeploymentService, allStatisticsRetriever, pricingStatsCollectorProvider, globalConfiguration, new SchedulerPricingMetricsSamplerTaskManager(schedulerService, METRICS_SCHEDULER_THREAD_NAME, 1L, TimeUnit.MINUTES));
    }

    public UbpMetricsDeploymentListener(DeploymentService runtimeDeploymentService, AllStatisticsRetriever allStatisticsRetriever, PricingCollectorProvider pricingStatsCollectorProvider, Map<String, Object> globalConfiguration, SchedulerPricingMetricsSamplerTaskManager pricingSamplerManager) {
        this.runtimeDeploymentService = runtimeDeploymentService;
        this.allStatisticsRetriever = allStatisticsRetriever;
        this.pricingStatsCollectorProvider = pricingStatsCollectorProvider;
        this.globalConfiguration = globalConfiguration;
        this.pricingSamplerManager = pricingSamplerManager;
        this.pricingSamplerManager.startSampling();
    }

    public UbpMetricsDeploymentListener(DeploymentService runtimeDeploymentService, SchedulerService schedulerService, Map<String, Object> globalConfiguration) {
        this(runtimeDeploymentService, schedulerService, new DefaultAllStatisticsRetriever(), new PricingCollectorProvider(), globalConfiguration);
    }

    public void onDeploymentSuccess(String applicationName) {
        Application application = this.runtimeDeploymentService.findApplication(applicationName);
        if (application == null) {
            throw new UpbMetricsException(String.format("The application could not be found on deployment success. Application: %s", applicationName));
        }
        AllStatistics allStatistics = this.allStatisticsRetriever.getAllStatistics(application);
        HashMap<String, Object> applicationConfiguration = new HashMap<String, Object>();
        applicationConfiguration.putAll(this.globalConfiguration);
        applicationConfiguration.put("mulesoft.ingest.group", "invocation_usage");
        applicationConfiguration.put("sampler_name", applicationName);
        this.getPricingStatsCollector(allStatistics, this.getCollectorRegistry(this.pricingSamplerManager, application, applicationConfiguration)).startCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PricingStatsCollector getPricingStatsCollector(AllStatistics allStatistics, CollectorRegistry collectorRegistry) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            PricingStatsCollector pricingStatsCollector = this.pricingStatsCollectorProvider.pricingStatsCollector(allStatistics, collectorRegistry);
            return pricingStatsCollector;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    public void onUndeploymentSuccess(String artifactName) {
        this.pricingSamplerManager.removePricingSamplerFor(artifactName);
    }

    protected abstract CollectorRegistry getCollectorRegistry(PricingSamplerTaskManager var1, Application var2, Map<String, Object> var3);
}

