/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import java.util.Objects;
import org.mule.runtime.api.message.ErrorType;

public class ErrorTypeBuilder {

    public static final class ErrorTypeImplementation
    implements ErrorType {
        private static final long serialVersionUID = -3716206147606234572L;
        private final String identifier;
        private final String namespace;
        private final ErrorType parentErrorType;
        private final String asString;

        private ErrorTypeImplementation(String identifier, String namespace, ErrorType parentErrorType) {
            this.identifier = identifier;
            this.namespace = namespace;
            this.parentErrorType = parentErrorType;
            this.asString = String.format("%s:%s", namespace, identifier);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ErrorType getParentErrorType() {
            return this.parentErrorType;
        }

        public String toString() {
            return this.asString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ErrorTypeImplementation that = (ErrorTypeImplementation)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.parentErrorType, that.parentErrorType);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.namespace, this.parentErrorType);
        }
    }
}

