/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import java.util.Objects;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;
import org.mule.runtime.ast.privileged.error.DefaultErrorType;
import org.mule.sdk.api.error.MuleErrors;

public final class DefaultErrorTypeBuilder
implements ErrorTypeBuilder {
    public static final String CORE_NAMESPACE_NAME = "mule".toUpperCase();
    public static final String ANY_IDENTIFIER = MuleErrors.ANY.name();
    public static final String CRITICAL_IDENTIFIER = MuleErrors.CRITICAL.name();
    private String identifier;
    private String namespace;
    private ErrorType parentErrorType;

    public static DefaultErrorTypeBuilder builder() {
        return new DefaultErrorTypeBuilder();
    }

    private DefaultErrorTypeBuilder() {
    }

    @Override
    public DefaultErrorTypeBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Override
    public DefaultErrorTypeBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    @Override
    public DefaultErrorTypeBuilder parentErrorType(ErrorType parentErrorType) {
        this.parentErrorType = parentErrorType;
        return this;
    }

    @Override
    public ErrorType build() {
        Objects.requireNonNull(this.identifier, "string representation cannot be null");
        Objects.requireNonNull(this.namespace, "namespace representation cannot be null");
        if (!this.isRoot()) {
            Objects.requireNonNull(this.parentErrorType, "parent error type cannot be null");
        }
        return new DefaultErrorType(this.identifier, this.namespace, this.parentErrorType);
    }

    private boolean isRoot() {
        return (this.identifier.equals(ANY_IDENTIFIER) || this.identifier.equals(CRITICAL_IDENTIFIER)) && this.namespace.equals(CORE_NAMESPACE_NAME);
    }
}

