/*
 * Decompiled with CFR 0.152.
 */
package org.mulesoft.anypoint.exchange.client;

import java.io.Serializable;
import java.net.UnknownHostException;
import org.mulesoft.als.logger.Logger$;
import org.mulesoft.anypoint.exchange.client.exception.ExchangeBadRequestException;
import org.mulesoft.anypoint.exchange.client.exception.ExchangeForbiddenException;
import org.mulesoft.anypoint.exchange.client.exception.ExchangeNotFoundException;
import org.mulesoft.anypoint.exchange.client.exception.ExchangeUnauthorizedException;
import org.mulesoft.anypoint.exchange.client.exception.ExchangeUnexpectedException;
import org.mulesoft.anypoint.exchange.client.model.ExchangeFile;
import org.mulesoft.anypoint.exchange.client.model.ExchangeMetadataResponse;
import org.mulesoft.anypoint.exchange.client.util.AssetDownloaderUtil;
import org.mulesoft.anypoint.server.platform.client.exchange.ExchangeClientConnectionProvider;
import org.mulesoft.apb.repository.client.common.exchange.ExchangeAssetResponse;
import org.mulesoft.apb.repository.client.common.exchange.ExchangeRequestData;
import org.mulesoft.apb.repository.client.scala.exchange.ExchangeClient;
import org.mulesoft.lsp.feature.telemetry.MessageTypes$;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001B\u000e\u001d\u0001\u001dB\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\t\u0002!\t!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0003K\u0011\u00191\u0006\u0001)A\u0005\u0017\"9q\u000b\u0001b\u0001\n#A\u0006B\u00022\u0001A\u0003%\u0011\fC\u0004d\u0001\t\u0007I\u0011\u00033\t\r-\u0004\u0001\u0015!\u0003f\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u001d\t\t\u0001\u0001C!\u0003\u0007Aq!a\u0004\u0001\t\u0013\t\t\u0002C\u0004\u0002\u0016\u0001!I!a\u0006\t\u000f\u0005%\u0002\u0001\"\u0003\u0002,!9\u0011\u0011\u0007\u0001\u0005\n\u0005M\u0002bBA\u001c\u0001\u0011%\u0011\u0011\b\u0005\b\u0003\u000f\u0002A\u0011AA%\u0011\u001d\t9\u0006\u0001C\u0005\u000332a!!\u0018\u0001#\u0005}\u0003\"CA1%\t\u0005\t\u0015!\u0003L\u0011\u0019!%\u0003\"\u0001\u0002d!9\u00111\u000e\n\u0005\u0002\u00055\u0004\"CA8\u0001\u0005\u0005I1AA9\u0011\u001d\t)\b\u0001C\u0005\u0003oBq!a!\u0001\t\u0013\t)\tC\u0004\u0002\"\u0002!I!a)\t\u000f\u0005-\u0006\u0001\"\u0003\u0002.\n)\"J^7Fq\u000eD\u0017M\\4f\u00072LWM\u001c;J[Bd'BA\u000f\u001f\u0003\u0019\u0019G.[3oi*\u0011q\u0004I\u0001\tKb\u001c\u0007.\u00198hK*\u0011\u0011EI\u0001\tC:L\bo\\5oi*\u00111\u0005J\u0001\t[VdWm]8gi*\tQ%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001Q9\u0002\"!\u000b\u0017\u000e\u0003)R\u0011aK\u0001\u0006g\u000e\fG.Y\u0005\u0003[)\u0012a!\u00118z%\u00164\u0007CA\u00188\u001b\u0005\u0001$BA\u00102\u0015\tY#G\u0003\u0002\u001eg)\u0011A'N\u0001\u000be\u0016\u0004xn]5u_JL(B\u0001\u001c#\u0003\r\t\u0007OY\u0005\u0003qA\u0012a\"\u0012=dQ\u0006tw-Z\"mS\u0016tG/\u0001\u0005qe>4\u0018\u000eZ3s!\tY$)D\u0001=\u0015\tyRH\u0003\u0002\u001e})\u0011q\bQ\u0001\ta2\fGOZ8s[*\u0011\u0011\tI\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\rc$\u0001I#yG\"\fgnZ3DY&,g\u000e^\"p]:,7\r^5p]B\u0013xN^5eKJ\fa\u0001P5oSRtDC\u0001$I!\t9\u0005!D\u0001\u001d\u0011\u0015I$\u00011\u0001;\u0003EQg/\\#yG\"\fgnZ3DY&,g\u000e^\u000b\u0002\u0017B\u0011Aj\u0015\b\u0003\u001bF\u0003\"A\u0014\u0016\u000e\u0003=S!\u0001\u0015\u0014\u0002\rq\u0012xn\u001c;?\u0013\t\u0011&&\u0001\u0004Qe\u0016$WMZ\u0005\u0003)V\u0013aa\u0015;sS:<'B\u0001*+\u0003IQg/\\#yG\"\fgnZ3DY&,g\u000e\u001e\u0011\u0002\u0019I,7\u000f\u001e+f[Bd\u0017\r^3\u0016\u0003e\u0003\"A\u00171\u000e\u0003mS!!\b/\u000b\u0005us\u0016aA<fE*\u0011q\fJ\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW&\u0011\u0011m\u0017\u0002\r%\u0016\u001cH\u000fV3na2\fG/Z\u0001\u000ee\u0016\u001cH\u000fV3na2\fG/\u001a\u0011\u0002'\u0005\u001c8/\u001a;E_^tGn\\1eKJ,F/\u001b7\u0016\u0003\u0015\u0004\"AZ5\u000e\u0003\u001dT!\u0001\u001b\u000f\u0002\tU$\u0018\u000e\\\u0005\u0003U\u001e\u00141#Q:tKR$un\u001e8m_\u0006$WM]+uS2\fA#Y:tKR$un\u001e8m_\u0006$WM]+uS2\u0004\u0013aC4fi6+G/\u00193bi\u0006$\"A\\>\u0011\u0007=\u0014H/D\u0001q\u0015\t\t(&\u0001\u0006d_:\u001cWO\u001d:f]RL!a\u001d9\u0003\r\u0019+H/\u001e:f!\t)\u00180D\u0001w\u0015\tyrO\u0003\u0002ye\u000511m\\7n_:L!A\u001f<\u00031\u0015C8\r[1oO\u0016lU\r^1eCR\f'+Z:q_:\u001cX\rC\u0003}\u0013\u0001\u0007Q0\u0001\u0003eCR\f\u0007CA;\u007f\u0013\tyhOA\nFq\u000eD\u0017M\\4f%\u0016\fX/Z:u\t\u0006$\u0018-\u0001\u0005hKR\f5o]3u)\u0011\t)!!\u0004\u0011\t=\u0014\u0018q\u0001\t\u0004k\u0006%\u0011bAA\u0006m\n)R\t_2iC:<W-Q:tKR\u0014Vm\u001d9p]N,\u0007\"\u0002?\u000b\u0001\u0004i\u0018\u0001E4fi\u0006\u001b8/\u001a;Gk:\u001cG/[8o)\u0011\t)!a\u0005\t\u000bq\\\u0001\u0019A?\u00029\u0019LG\u000e\\#yG\"\fgnZ3NKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKR\u0019A/!\u0007\t\u000f\u0005mA\u00021\u0001\u0002\u001e\u0005)a/\u00197vKB!\u0011qDA\u0013\u001b\t\t\tCC\u0002\u0002$q\tQ!\\8eK2LA!a\n\u0002\"\taQ\t_2iC:<WMR5mK\u0006ia-\u001a;dQ6+G/\u00193bi\u0006$B!!\f\u00020A!qN]A\u000f\u0011\u0015aX\u00021\u0001~\u0003M9WM\\3sCR,WI\u001c3q_&tG/\u0016:m)\rY\u0015Q\u0007\u0005\u0006y:\u0001\r!`\u0001\u0012M\u0006dGNY1dWB\u0013X\rZ5dCR,GCBA\u001e\u0003\u0003\n\u0019\u0005E\u0002*\u0003{I1!a\u0010+\u0005\u001d\u0011un\u001c7fC:DQ\u0001`\bA\u0002uDq!!\u0012\u0010\u0001\u0004\ti\"\u0001\u0003gS2,\u0017!\u00039sK\u0012L7-\u0019;f)!\tY$a\u0013\u0002P\u0005M\u0003bBA'!\u0001\u0007\u0011QD\u0001\rKb\u001c\u0007.\u00198hK\u001aKG.\u001a\u0005\u0007\u0003#\u0002\u0002\u0019A&\u0002\u0015\rd\u0017m]:jM&,'\u000f\u0003\u0004\u0002VA\u0001\raS\u0001\na\u0006\u001c7.Y4j]\u001e\fq\u0001Z3gCVdG\u000f\u0006\u0003\u0002<\u0005m\u0003bBA'#\u0001\u0007\u0011Q\u0004\u0002\n'R\u0014\u0018N\\4PaN\u001c\"A\u0005\u0015\u0002\u0003M$B!!\u001a\u0002jA\u0019\u0011q\r\n\u000e\u0003\u0001Aa!!\u0019\u0015\u0001\u0004Y\u0015a\u00048p]\u0016k\u0007\u000f^=O_JtU\u000f\u001c7\u0015\u0005\u0005m\u0012!C*ue&twm\u00149t)\u0011\t)'a\u001d\t\r\u0005\u0005d\u00031\u0001L\u0003\u00151W\r^2i)\u0011\tI(a \u0011\t=\u0014\u00181\u0010\t\u0005\u0003?\ti(C\u0002{\u0003CAa!!!\u0018\u0001\u0004Y\u0015\u0001C3oIB|\u0017N\u001c;\u0002!%\u001c\b\n\u001e;q'R\fG/^:D_\u0012,GCBA\u001e\u0003\u000f\u000b9\nC\u0004\u0002\nb\u0001\r!a#\u0002\t\r|G-\u001a\t\u0005\u0003\u001b\u000b\u0019*\u0004\u0002\u0002\u0010*\u0019\u0011\u0011\u00130\u0002\t!$H\u000f]\u0005\u0005\u0003+\u000byI\u0001\u0006IiR\u00048\u000b^1ukNDq!!'\u0019\u0001\u0004\tY*A\u0001f!\rQ\u0016QT\u0005\u0004\u0003?[&\u0001\u0007%uiB\u001cE.[3oi\u0016\u0013(o\u001c:Fq\u000e,\u0007\u000f^5p]\u0006Qq-\u001a;IK\u0006$WM]:\u0016\u0005\u0005\u0015\u0006\u0003BAG\u0003OKA!!+\u0002\u0010\nY\u0001\n\u001e;q\u0011\u0016\fG-\u001a:t\u0003%1W\r^2i\r&dW\r\u0006\u0003\u00020\u0006u\u0006\u0003B8s\u0003c\u0003R!KAZ\u0003oK1!!.+\u0005\u0015\t%O]1z!\rI\u0013\u0011X\u0005\u0004\u0003wS#\u0001\u0002\"zi\u0016Da!a0\u001b\u0001\u0004Y\u0015a\u00024jY\u0016,&\u000f\u001c")
public class JvmExchangeClientImpl
implements ExchangeClient {
    private final ExchangeClientConnectionProvider provider;
    private final String org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient;
    private final RestTemplate restTemplate;
    private final AssetDownloaderUtil assetDownloaderUtil;

    public String org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient() {
        return this.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient;
    }

    public RestTemplate restTemplate() {
        return this.restTemplate;
    }

    public AssetDownloaderUtil assetDownloaderUtil() {
        return this.assetDownloaderUtil;
    }

    public Future<org.mulesoft.apb.repository.client.common.exchange.ExchangeMetadataResponse> getMetadata(ExchangeRequestData data) {
        return Logger$.MODULE$.timeProcess("Start getMetada in JvmExchangeClient", MessageTypes$.MODULE$.BEGIN_GET_METADATA(), MessageTypes$.MODULE$.END_GET_METADATA(), this.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient().concat(":getMetadata"), data.payload().gav().path(), (Function0 & Serializable & scala.Serializable)() -> this.fetchMetadata(data).map((Function1 & Serializable & scala.Serializable)value -> this.fillExchangeMetadataResponse((ExchangeFile)value), ExecutionContext.Implicits$.MODULE$.global()), Logger$.MODULE$.timeProcess$default$7());
    }

    public Future<ExchangeAssetResponse> getAsset(ExchangeRequestData data) {
        return Logger$.MODULE$.timeProcess("Start getAsset in JvmExchangeClient", MessageTypes$.MODULE$.BEGIN_GET_ASSET(), MessageTypes$.MODULE$.END_GET_ASSET(), this.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient().concat(":getAsset"), data.payload().gav().path(), (Function0 & Serializable & scala.Serializable)() -> this.getAssetFunction(data), Logger$.MODULE$.timeProcess$default$7());
    }

    private Future<ExchangeAssetResponse> getAssetFunction(ExchangeRequestData data) {
        return this.fetchMetadata(data).flatMap((Function1 & Serializable & scala.Serializable)metadata -> this.fetchFile(metadata.getExternalLink()).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JvmExchangeClientImpl $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof UnknownHostException) {
                    UnknownHostException unknownHostException = (UnknownHostException)A1;
                    Logger$.MODULE$.error(new StringBuilder(21).append("Error getting Asset: ").append(unknownHostException.getMessage()).toString(), this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient(), "getAssetFunction");
                    throw new ExchangeUnexpectedException(unknownHostException.getMessage());
                }
                if (A1 instanceof Exception) {
                    Exception exception = (Exception)A1;
                    Logger$.MODULE$.error(new StringBuilder(21).append("Error getting Asset: ").append(exception.getMessage()).toString(), this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient(), "getAssetFunction");
                    throw exception;
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof UnknownHostException ? true : throwable instanceof Exception;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ExecutionContext.Implicits$.MODULE$.global()).map((Function1 & Serializable & scala.Serializable)response -> new ExchangeAssetResponse(this.fillExchangeMetadataResponse((ExchangeFile)metadata), response), ExecutionContext.Implicits$.MODULE$.global()), ExecutionContext.Implicits$.MODULE$.global());
    }

    private org.mulesoft.apb.repository.client.common.exchange.ExchangeMetadataResponse fillExchangeMetadataResponse(ExchangeFile value) {
        return new org.mulesoft.apb.repository.client.common.exchange.ExchangeMetadataResponse(value.getUpdatedDate(), value.getPackaging(), value.getClassifier());
    }

    private Future<ExchangeFile> fetchMetadata(ExchangeRequestData data) {
        return this.fetch(this.generateEndpointUrl(data)).map((Function1 & Serializable & scala.Serializable)response -> (ExchangeFile)Option$.MODULE$.apply((Object)response.getData().getAsset().getFiles()).flatMap((Function1 & Serializable & scala.Serializable)files -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).find((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.predicate(file, data.payload().classifier(), data.payload().packaging()))).orElse((Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).find((Function1 & Serializable & scala.Serializable)file -> BoxesRunTime.boxToBoolean((boolean)this.fallbackPredicate(data, file))))).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Logger$.MODULE$.error("Error fetching Metadata, Metadata item not found", this.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient(), "fetchMetadata");
            throw new ExchangeNotFoundException("Metadata item not found");
        }), ExecutionContext.Implicits$.MODULE$.global());
    }

    private String generateEndpointUrl(ExchangeRequestData data) {
        return this.provider.getEndpoint().concat(data.payload().gav().path());
    }

    private boolean fallbackPredicate(ExchangeRequestData data, ExchangeFile file) {
        return !this.StringOps(data.payload().classifier()).nonEmptyNorNull() && !this.StringOps(data.payload().packaging()).nonEmptyNorNull() && this.default(file);
    }

    public boolean predicate(ExchangeFile exchangeFile, String classifier, String packaging) {
        return this.StringOps(classifier).nonEmptyNorNull() && this.StringOps(packaging).nonEmptyNorNull() ? classifier.equalsIgnoreCase(exchangeFile.getClassifier()) && packaging.equalsIgnoreCase(exchangeFile.getPackaging()) : this.default(exchangeFile) && this.StringOps(exchangeFile.getMainFile()).nonEmptyNorNull();
    }

    private boolean default(ExchangeFile exchangeFile) {
        return !Predef$.MODULE$.Boolean2boolean(exchangeFile.getGenerated()) && !exchangeFile.getClassifier().startsWith("fat-");
    }

    public StringOps StringOps(String s) {
        return new StringOps(this, s);
    }

    private Future<ExchangeMetadataResponse> fetch(String endpoint) {
        HttpEntity entity = new HttpEntity((MultiValueMap)this.getHeaders());
        return Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (ExchangeMetadataResponse)this.restTemplate().exchange(endpoint, HttpMethod.GET, entity, ExchangeMetadataResponse.class, new Object[0]).getBody(), ExecutionContext.Implicits$.MODULE$.global()).recoverWith((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ JvmExchangeClientImpl $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                boolean bl = false;
                HttpClientErrorException httpClientErrorException = null;
                A1 A1 = x1;
                if (A1 instanceof HttpClientErrorException) {
                    bl = true;
                    httpClientErrorException = (HttpClientErrorException)A1;
                    if (this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$isHttpStatusCode(HttpStatus.UNAUTHORIZED, httpClientErrorException)) {
                        Logger$.MODULE$.error(new StringBuilder(30).append("Error on request to Exchange: ").append(httpClientErrorException.getMessage()).toString(), this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient(), "fetch");
                        throw new ExchangeUnauthorizedException(httpClientErrorException.getMessage());
                    }
                }
                if (bl && this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$isHttpStatusCode(HttpStatus.BAD_REQUEST, httpClientErrorException)) {
                    Logger$.MODULE$.error(new StringBuilder(30).append("Error on request to Exchange: ").append(httpClientErrorException.getMessage()).toString(), this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient(), "fetch");
                    throw new ExchangeBadRequestException(httpClientErrorException.getMessage());
                }
                if (bl && this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$isHttpStatusCode(HttpStatus.FORBIDDEN, httpClientErrorException)) {
                    Logger$.MODULE$.error(new StringBuilder(30).append("Error on request to Exchange: ").append(httpClientErrorException.getMessage()).toString(), this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient(), "fetch");
                    throw new ExchangeForbiddenException(httpClientErrorException.getMessage());
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(Throwable x1) {
                boolean bl = false;
                HttpClientErrorException httpClientErrorException = null;
                Throwable throwable = x1;
                if (throwable instanceof HttpClientErrorException) {
                    bl = true;
                    httpClientErrorException = (HttpClientErrorException)throwable;
                    if (this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$isHttpStatusCode(HttpStatus.UNAUTHORIZED, httpClientErrorException)) {
                        return true;
                    }
                }
                if (bl && this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$isHttpStatusCode(HttpStatus.BAD_REQUEST, httpClientErrorException)) {
                    return true;
                }
                if (!bl) return false;
                if (!this.$outer.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$isHttpStatusCode(HttpStatus.FORBIDDEN, httpClientErrorException)) return false;
                return true;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, ExecutionContext.Implicits$.MODULE$.global());
    }

    public boolean org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$isHttpStatusCode(HttpStatus code, HttpClientErrorException e) {
        return code.value() == e.getStatusCode().value();
    }

    /*
     * WARNING - void declaration
     */
    private HttpHeaders getHeaders() {
        void var1_1;
        HttpHeaders headers = new HttpHeaders();
        Option$.MODULE$.apply((Object)this.provider.getToken()).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            headers.add("Authorization", x$2);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.provider.getOwnerId()).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            headers.add("x-owner-id", x$3);
            return BoxedUnit.UNIT;
        });
        Option$.MODULE$.apply((Object)this.provider.getOrganizationId()).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            headers.add("x-organization-id", x$4);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    private Future<byte[]> fetchFile(String fileUrl) {
        Future future;
        if (this.StringOps(fileUrl).nonEmptyNorNull()) {
            future = this.assetDownloaderUtil().downloadAsset(fileUrl);
        } else {
            Logger$.MODULE$.error("Asset URL is empty", this.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient(), "fetchFile");
            future = Future$.MODULE$.failed((Throwable)new ExchangeBadRequestException("Asset URL is empty"));
        }
        return future;
    }

    public JvmExchangeClientImpl(ExchangeClientConnectionProvider provider) {
        this.provider = provider;
        this.org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$$jvmExchangeClient = "JvmExchangeClient";
        this.restTemplate = new RestTemplate();
        this.assetDownloaderUtil = new AssetDownloaderUtil();
    }

    public class StringOps {
        private final String s;
        public final /* synthetic */ JvmExchangeClientImpl $outer;

        public boolean nonEmptyNorNull() {
            return Option$.MODULE$.apply((Object)this.s).exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StringOps.$anonfun$nonEmptyNorNull$1(x$1)));
        }

        public /* synthetic */ JvmExchangeClientImpl org$mulesoft$anypoint$exchange$client$JvmExchangeClientImpl$StringOps$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$nonEmptyNorNull$1(String x$1) {
            return new scala.collection.immutable.StringOps(Predef$.MODULE$.augmentString(x$1)).nonEmpty();
        }

        public StringOps(JvmExchangeClientImpl $outer, String s) {
            this.s = s;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

