/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mulesoft.agent.domain.monitoring.Metric;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricClassification {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricClassification.class);
    private final Map<String, List<Metric>> classification = Maps.newHashMap();

    public MetricClassification(List<String> keys, List<Metric> sample) {
        this.classify(keys, sample);
    }

    private void classify(List<String> keys, List<Metric> sample) {
        if (sample == null || keys == null) {
            return;
        }
        LOGGER.debug("Classifying {} metrics for {} keys.", (Object)sample.size(), (Object)keys.size());
        block0: for (Metric metric : sample) {
            if (metric == null || metric.getValue() == null || StringUtils.isBlank((String)metric.getName())) continue;
            for (String classifier : keys) {
                if (classifier == null || !classifier.equalsIgnoreCase(metric.getName())) continue;
                String key = metric.getName();
                LinkedList metricClassification = this.classification.get(key);
                if (metricClassification == null) {
                    metricClassification = Lists.newLinkedList();
                    this.classification.put(key, metricClassification);
                }
                metricClassification.add(metric);
                continue block0;
            }
        }
        LOGGER.debug("Classification map ended up with {} pairs", (Object)this.classification.size());
        LinkedList absentKeys = Lists.newLinkedList();
        for (String key : keys) {
            if (this.classification.keySet().contains(key)) continue;
            absentKeys.add(key);
        }
        LOGGER.debug("Absent keys: " + ((Object)absentKeys).toString());
    }

    public Map<String, List<Metric>> getClassification() {
        return this.classification;
    }

    public List<Metric> getMetrics(String key) {
        LinkedList metrics = this.classification.get(key);
        return metrics != null ? metrics : Lists.newLinkedList();
    }

    public Set<String> getKeys() {
        return this.classification.keySet();
    }
}

