/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest.model;

import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricSample;
import java.util.Date;
import java.util.List;

public class DefaultMetricSample
implements MetricSample {
    private final Date date;
    private final Double min;
    private final Double max;
    private final Double sum;
    private final Double avg;
    private final Double count;

    public DefaultMetricSample(Date date, Double min, Double max, Double sum, Double avg, Double count) {
        this.date = date;
        this.min = min;
        this.max = max;
        this.sum = sum;
        this.avg = avg;
        this.count = count;
    }

    public DefaultMetricSample(List<Metric> sample) {
        Double min = null;
        Double max = null;
        Double sum = 0.0;
        Double count = 0.0;
        Date date = null;
        if (sample != null) {
            for (Metric metric : sample) {
                if (metric == null || metric.getValue() == null) continue;
                double value = metric.getValue().doubleValue();
                if (max == null || max < value) {
                    max = value;
                }
                if (min == null || min > value) {
                    min = value;
                }
                sum = sum + value;
                count = count + 1.0;
                if (date != null && date.getTime() >= metric.getTimestamp()) continue;
                date = new Date(metric.getTimestamp());
            }
        }
        this.max = max;
        this.min = min;
        this.sum = sum;
        this.avg = count > 0.0 ? sum / count : 0.0;
        this.count = count;
        this.date = date != null ? date : new Date();
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public Double getMin() {
        return this.min;
    }

    @Override
    public Double getMax() {
        return this.max;
    }

    @Override
    public Double getSum() {
        return this.sum;
    }

    @Override
    public Double getAvg() {
        return this.avg;
    }

    @Override
    public Double getCount() {
        return this.count;
    }

    public String toString() {
        return "DefaultMetricSample{date=" + this.date + ", min=" + this.min + ", max=" + this.max + ", sum=" + this.sum + ", avg=" + this.avg + ", count=" + this.count + '}';
    }
}

