/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest.factory;

import com.google.common.base.Preconditions;
import com.mulesoft.agent.domain.monitoring.SupportedJMXBean;
import com.mulesoft.agent.monitoring.publisher.ingest.builder.IngestMetricBuilder;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricClassification;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricSample;
import com.mulesoft.agent.monitoring.publisher.ingest.model.api.IngestMetric;
import java.util.List;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class TargetMetricFactory {
    private static final Logger LOGGER = LogManager.getLogger(TargetMetricFactory.class);
    @Inject
    private IngestMetricBuilder metricBuilder;

    TargetMetricFactory() {
    }

    TargetMetricFactory(IngestMetricBuilder metricBuilder) {
        this.metricBuilder = metricBuilder;
    }

    public boolean appliesForMetric(SupportedJMXBean bean) {
        return this.getSupportedMetrics().contains(bean);
    }

    public IngestMetric apply(MetricClassification classification, SupportedJMXBean bean) {
        Preconditions.checkArgument((boolean)this.appliesForMetric(bean), (Object)String.format("Invoked factory does not apply for %s, make sure you are checking with appliesForMetric first.", bean.name()));
        if (classification != null && classification.getKeys().contains(bean.getMetricName())) {
            MetricSample sample = this.doApply(classification, bean);
            if (sample.getCount() <= 0.0 || sample.getAvg() < 0.0 || sample.getSum() < 0.0 || sample.getMax() < 0.0 || sample.getMin() < 0.0) {
                LOGGER.debug("Metric sample for bean {} returned with invalid values. {}", (Object)bean.name(), (Object)sample);
                return null;
            }
            return this.metricBuilder.build(sample);
        }
        return null;
    }

    abstract List<SupportedJMXBean> getSupportedMetrics();

    abstract MetricSample doApply(MetricClassification var1, SupportedJMXBean var2);
}

