/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest.factory;

import com.google.common.collect.Lists;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.domain.monitoring.SupportedJMXBean;
import com.mulesoft.agent.monitoring.publisher.ingest.factory.TargetMetricFactory;
import com.mulesoft.agent.monitoring.publisher.ingest.model.DefaultMetricSample;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricClassification;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricSample;
import java.util.List;
import javax.inject.Named;

@Named(value="ingest.raw.metric.factory")
public class RawMetricFactory
extends TargetMetricFactory {
    private static final List<SupportedJMXBean> SUPPORTED_METRICS = Lists.newArrayList((Object[])new SupportedJMXBean[]{SupportedJMXBean.AVAILABLE_PROCESSORS, SupportedJMXBean.CLASS_LOADING_LOADED, SupportedJMXBean.CLASS_LOADING_TOTAL, SupportedJMXBean.CLASS_LOADING_UNLOADED, SupportedJMXBean.LOAD_AVERAGE, SupportedJMXBean.THREADING_COUNT});

    @Override
    List<SupportedJMXBean> getSupportedMetrics() {
        return SUPPORTED_METRICS;
    }

    @Override
    MetricSample doApply(MetricClassification classification, SupportedJMXBean bean) {
        List<Metric> metrics = classification.getMetrics(bean.getMetricName());
        return new DefaultMetricSample(metrics);
    }
}

