/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest.factory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.domain.monitoring.SupportedJMXBean;
import com.mulesoft.agent.monitoring.publisher.ingest.builder.IngestMetricBuilder;
import com.mulesoft.agent.monitoring.publisher.ingest.decorator.PercentageMetricSampleDecorator;
import com.mulesoft.agent.monitoring.publisher.ingest.factory.TargetMetricFactory;
import com.mulesoft.agent.monitoring.publisher.ingest.model.DefaultMetricSample;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricClassification;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricSample;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.inject.Named;

@Named(value="ingest.garbageCollectionTime.metric.factory")
public class GarbageCollectionTimeMetricFactory
extends TargetMetricFactory {
    private Map<SupportedJMXBean, DefaultMetricSample> lastReadMetricContainer = Maps.newConcurrentMap();
    private Map<SupportedJMXBean, Double> lastReadUptimeContainer = Maps.newConcurrentMap();

    public GarbageCollectionTimeMetricFactory() {
    }

    public GarbageCollectionTimeMetricFactory(IngestMetricBuilder metricBuilder) {
        super(metricBuilder);
    }

    @Override
    List<SupportedJMXBean> getSupportedMetrics() {
        return Lists.newArrayList((Object[])new SupportedJMXBean[]{SupportedJMXBean.GC_COPY_TIME, SupportedJMXBean.GC_PAR_NEW_TIME, SupportedJMXBean.GC_PS_SCAVENGE_TIME, SupportedJMXBean.GC_G1_YOUNG_GENERATION_TIME, SupportedJMXBean.GC_MARK_SWEEP_TIME, SupportedJMXBean.GC_PS_MARK_SWEEP_TIME, SupportedJMXBean.GC_G1_OLD_GENERATION_TIME});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    MetricSample doApply(MetricClassification classification, SupportedJMXBean bean) {
        Double currentUptime = this.getCurrentUptime(classification);
        Double lastUptime = this.getLastReadUptime(bean);
        List<Metric> currentReadMetrics = classification.getMetrics(bean.getMetricName());
        DefaultMetricSample currentRead = new DefaultMetricSample(currentReadMetrics);
        DefaultMetricSample lastRead = this.getLastReadMetric(bean);
        try {
            if (lastRead == null || lastUptime == null || lastUptime.equals(currentUptime)) {
                MetricSample metricSample = this.calculate(currentRead.getDate(), currentRead.getMin(), currentRead.getMax(), currentRead.getSum(), currentRead.getAvg(), currentRead.getCount(), currentUptime);
                return metricSample;
            }
            Double period = currentUptime - lastUptime;
            MetricSample metricSample = this.calculate(currentRead.getDate(), currentRead.getMin() - lastRead.getMin(), currentRead.getMax() - lastRead.getMax(), currentRead.getSum() - lastRead.getSum(), currentRead.getAvg() - lastRead.getAvg(), currentRead.getCount(), period);
            return metricSample;
        }
        finally {
            this.setLastReadMetric(bean, currentRead);
            this.setLastReadUptime(bean, currentUptime);
        }
    }

    private MetricSample calculate(Date date, Double min, Double max, Double sum, Double avg, Double count, Double period) {
        Preconditions.checkArgument((period > 0.0 ? 1 : 0) != 0, (Object)"Period between last read and now should never be less than zero.");
        return this.build(date, min / period, max / period, sum / period, avg / period, count);
    }

    private MetricSample build(Date date, Double min, Double max, Double sum, Double avg, Double count) {
        return new PercentageMetricSampleDecorator(new DefaultMetricSample(date, min > 0.0 ? min : 0.0, max > 0.0 ? max : 0.0, sum > 0.0 ? sum : 0.0, avg > 0.0 ? avg : 0.0, count));
    }

    private void setLastReadMetric(SupportedJMXBean bean, DefaultMetricSample currentRead) {
        this.lastReadMetricContainer.put(bean, currentRead);
    }

    private DefaultMetricSample getLastReadMetric(SupportedJMXBean bean) {
        return this.lastReadMetricContainer.get(bean);
    }

    private Double getCurrentUptime(MetricClassification classification) {
        List<Metric> uptimeMetrics = classification.getMetrics(SupportedJMXBean.JVM_UPTIME.getMetricName());
        DefaultMetricSample uptimeMetric = new DefaultMetricSample(uptimeMetrics);
        return uptimeMetric.getAvg();
    }

    private void setLastReadUptime(SupportedJMXBean bean, Double currentUptime) {
        this.lastReadUptimeContainer.put(bean, currentUptime);
    }

    private Double getLastReadUptime(SupportedJMXBean bean) {
        return this.lastReadUptimeContainer.get(bean);
    }
}

