/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest.factory;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.domain.monitoring.SupportedJMXBean;
import com.mulesoft.agent.monitoring.publisher.ingest.factory.TargetMetricFactory;
import com.mulesoft.agent.monitoring.publisher.ingest.model.DefaultMetricSample;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricClassification;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricSample;
import java.util.List;
import java.util.Map;
import javax.inject.Named;

@Named(value="ingest.garbageCollectionCount.metric.factory")
public class GarbageCollectionCountMetricFactory
extends TargetMetricFactory {
    private Map<SupportedJMXBean, DefaultMetricSample> lastReadMetricContainer = Maps.newConcurrentMap();

    @Override
    List<SupportedJMXBean> getSupportedMetrics() {
        return Lists.newArrayList((Object[])new SupportedJMXBean[]{SupportedJMXBean.GC_COPY_COUNT, SupportedJMXBean.GC_PAR_NEW_COUNT, SupportedJMXBean.GC_PS_SCAVENGE_COUNT, SupportedJMXBean.GC_G1_YOUNG_GENERATION_COUNT, SupportedJMXBean.GC_MARK_SWEEP_COUNT, SupportedJMXBean.GC_PS_MARK_SWEEP_COUNT, SupportedJMXBean.GC_G1_OLD_GENERATION_COUNT});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    MetricSample doApply(MetricClassification classification, SupportedJMXBean bean) {
        List<Metric> currentReadMetrics = classification.getMetrics(bean.getMetricName());
        DefaultMetricSample currentRead = new DefaultMetricSample(currentReadMetrics);
        DefaultMetricSample lastRead = this.getLastReadMetric(bean);
        try {
            if (lastRead == null) {
                DefaultMetricSample defaultMetricSample = currentRead;
                return defaultMetricSample;
            }
            DefaultMetricSample defaultMetricSample = new DefaultMetricSample(currentRead.getDate(), currentRead.getMin() - lastRead.getMin(), currentRead.getMax() - lastRead.getMax(), currentRead.getSum() - lastRead.getSum(), currentRead.getAvg() - lastRead.getAvg(), currentRead.getCount());
            return defaultMetricSample;
        }
        finally {
            this.setLastReadMetric(bean, currentRead);
        }
    }

    private void setLastReadMetric(SupportedJMXBean bean, DefaultMetricSample currentRead) {
        this.lastReadMetricContainer.put(bean, currentRead);
    }

    private DefaultMetricSample getLastReadMetric(SupportedJMXBean bean) {
        return this.lastReadMetricContainer.get(bean);
    }
}

