/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.monitoring.publisher.ingest.model.api.IngestApplicationMetricPostBody;
import com.mulesoft.agent.monitoring.publisher.ingest.model.api.IngestMetric;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.Response;

public final class AnypointMonitoringIngestAPIClient {
    private static final Logger LOGGER = LogManager.getLogger(AnypointMonitoringIngestAPIClient.class);
    private static final String APPLICATION_NAME_HEADER = "X-APPLICATION-NAME";
    private final String targetMetricsPath;
    private final String applicationMetricsPath;
    private final AuthenticationProxyClient authProxyClient;

    private AnypointMonitoringIngestAPIClient(String apiVersion, AuthenticationProxyClient authProxyClient) {
        this.targetMetricsPath = String.format("/monitoring/ingest/api/v%s/targets", apiVersion);
        this.applicationMetricsPath = String.format("/monitoring/ingest/api/v%s/applications", apiVersion);
        this.authProxyClient = authProxyClient;
    }

    public static AnypointMonitoringIngestAPIClient create(String apiVersion, AuthenticationProxyClient authProxyClient) {
        return new AnypointMonitoringIngestAPIClient(apiVersion, authProxyClient);
    }

    public Response postTargetMetrics(Map<String, Set<IngestMetric>> body) {
        Response httpResponse = this.authProxyClient.post(this.targetMetricsPath, body);
        if (Response.Status.Family.familyOf((int)httpResponse.getStatusCode()) != Response.Status.Family.SUCCESSFUL) {
            LOGGER.warn("Post of target metrics failed with status " + httpResponse.getStatusCode());
            if (LOGGER.isDebugEnabled()) {
                try {
                    LOGGER.debug("Post of target metrics failed with status " + httpResponse.getStatusCode() + ", response body: " + httpResponse.getResponseBody(Charset.forName("UTF-8")));
                }
                catch (Throwable e) {
                    LOGGER.warn(String.format("Could not read response body. cause: %s - %s", e.getClass().getSimpleName(), ExceptionUtils.getRootCauseMessage((Throwable)e)));
                    LOGGER.debug("Could not read response body from post target metrics response.", e);
                }
            }
        }
        return httpResponse;
    }

    public Response postApplicationMetrics(String applicationName, IngestApplicationMetricPostBody body) {
        HashMap headers = Maps.newHashMap();
        headers.put(APPLICATION_NAME_HEADER, Lists.newArrayList((Object[])new String[]{applicationName}));
        Response httpResponse = this.authProxyClient.post(this.applicationMetricsPath, (Object)body, (Map)headers);
        if (Response.Status.Family.familyOf((int)httpResponse.getStatusCode()) != Response.Status.Family.SUCCESSFUL) {
            LOGGER.warn(String.format("Post of application metrics for %s failed with status %d", applicationName, httpResponse.getStatusCode()));
            if (LOGGER.isDebugEnabled()) {
                try {
                    LOGGER.debug(String.format("Post of application metrics for %s failed with status %d, response body: %s", applicationName, httpResponse.getStatusCode(), httpResponse.getResponseBody(Charset.forName("UTF-8"))));
                }
                catch (Throwable e) {
                    LOGGER.warn(String.format("Could not read response body. cause: %s - %s", e.getClass().getSimpleName(), ExceptionUtils.getRootCauseMessage((Throwable)e)));
                    LOGGER.debug(String.format("Could not read response body from post application metrics for %s response.", applicationName), e);
                }
            }
        }
        return httpResponse;
    }
}

