/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.mulesoft.agent.configuration.NotAvailableOn;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.domain.monitoring.SupportedJMXBean;
import com.mulesoft.agent.handlers.exception.InitializationException;
import com.mulesoft.agent.monitoring.publisher.ingest.IngestMonitorPublisher;
import com.mulesoft.agent.monitoring.publisher.ingest.factory.TargetMetricFactory;
import com.mulesoft.agent.monitoring.publisher.ingest.model.JMXMetricFieldMapping;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricClassification;
import com.mulesoft.agent.monitoring.publisher.ingest.model.api.IngestMetric;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.Response;

@Singleton
@Named(value="mule.agent.ingest.target.metrics.internal.handler")
@NotAvailableOn(environment={RuntimeEnvironment.ON_PREM, RuntimeEnvironment.STANDALONE})
public class IngestTargetMonitorPublisher
extends IngestMonitorPublisher<ArrayList<Metric>> {
    private static final Logger LOGGER = LogManager.getLogger(IngestTargetMonitorPublisher.class);
    @Inject
    private List<TargetMetricFactory> targetMetricFactories;

    @Override
    public void initialize() throws InitializationException {
        super.initialize();
        if (this.targetMetricFactories == null) {
            throw new InitializationException("Target metric factories weren't injected!");
        }
    }

    private Map<String, Set<IngestMetric>> processTargetMetrics(Collection<ArrayList<Metric>> collection) {
        HashMap metricsResult = Maps.newHashMap();
        for (List list : collection) {
            LinkedList keys = Lists.newLinkedList();
            for (SupportedJMXBean bean : SupportedJMXBean.values()) {
                keys.add(bean.getMetricName());
            }
            MetricClassification classification = new MetricClassification(keys, list);
            for (SupportedJMXBean bean : SupportedJMXBean.values()) {
                TargetMetricFactory applicableFactory = null;
                for (TargetMetricFactory factory : this.targetMetricFactories) {
                    if (!factory.appliesForMetric(bean)) continue;
                    applicableFactory = factory;
                }
                if (applicableFactory == null) {
                    LOGGER.debug("No factory found for bean " + bean.name() + " in array of " + this.targetMetricFactories.size() + " factories.");
                    continue;
                }
                IngestMetric metric = applicableFactory.apply(classification, bean);
                if (metric == null || !(metric.getCount() > 0.0)) continue;
                String fieldName = JMXMetricFieldMapping.from(bean);
                Set existentMetrics = (Set)metricsResult.get(fieldName);
                if (existentMetrics != null) {
                    existentMetrics.add(metric);
                    continue;
                }
                metricsResult.put(fieldName, Sets.newHashSet((Object[])new IngestMetric[]{metric}));
            }
        }
        return metricsResult;
    }

    @Override
    protected boolean send(Collection<ArrayList<Metric>> collection) {
        LOGGER.debug("Publishing target metrics to ingest api.");
        try {
            Map<String, Set<IngestMetric>> targetBody = this.processTargetMetrics(collection);
            LOGGER.debug(targetBody);
            Response httpResponse = this.client.postTargetMetrics(targetBody);
            boolean successful = this.isSuccessStatusCode(httpResponse.getStatusCode());
            if (successful) {
                LOGGER.debug("Published target metrics to Ingest successfully");
            } else {
                LOGGER.warn("Could not publish target metrics to Ingest.");
            }
            return successful;
        }
        catch (Exception e) {
            LOGGER.warn("Could not publish target metrics to Ingest, cause: " + ExceptionUtils.getRootCauseMessage((Throwable)e));
            LOGGER.debug("Error: ", (Throwable)e);
            return false;
        }
    }
}

