/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.clients.AuthenticationProxyFactory;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.configuration.common.AuthenticationProxyConfiguration;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.handlers.exception.InitializationException;
import com.mulesoft.agent.handlers.internal.buffer.DiscardingMessageBufferConfigurationFactory;
import com.mulesoft.agent.monitoring.publisher.ingest.client.AnypointMonitoringIngestAPIClient;
import com.mulesoft.agent.services.OnOffSwitch;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

public abstract class IngestMonitorPublisher<T extends Serializable>
extends BufferedHandler<T> {
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SZ";
    private static final long FLUSH_FREQUENCY = 60000L;
    private static final int MAXIMUM_CAPACITY = 1000;
    @Inject
    private AuthenticationProxyFactory authenticationProxyFactory;
    @Configurable(value="{}")
    private AuthenticationProxyConfiguration authenticationProxy;
    @Configurable(value="1")
    private String apiVersion;
    @Configurable(value="true")
    private Boolean enabled;
    AnypointMonitoringIngestAPIClient client;
    OnOffSwitch enabledSwitch;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @PostConfigure
    public void postConfigurable() throws AgentEnableOperationException {
        if (this.enabledSwitch == null) {
            this.enabledSwitch = OnOffSwitch.newNullSwitch((boolean)this.enabled);
        }
    }

    public void initialize() throws InitializationException {
        if (!this.checkConfiguration()) {
            throw new InitializationException("Could not initialize ingest monitor publisher. Its configuration is invalid.");
        }
        ObjectMapper objectMapper = new ObjectMapper().setDateFormat((DateFormat)new SimpleDateFormat(DATE_FORMAT)).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        AuthenticationProxyClient authProxyClient = this.authenticationProxyFactory.create(this.authenticationProxy, objectMapper);
        this.client = AnypointMonitoringIngestAPIClient.create(this.apiVersion, authProxyClient);
        super.initialize();
    }

    public BufferConfiguration getBuffer() {
        if (this.buffer == null) {
            this.buffer = new DiscardingMessageBufferConfigurationFactory().create(60000L, 1000, BufferType.MEMORY, null);
        }
        return this.buffer;
    }

    private boolean checkConfiguration() {
        return this.authenticationProxy != null && this.authenticationProxy.getSecurity() != null && StringUtils.isNotBlank((String)this.authenticationProxy.getSecurity().getKeyStoreAlias()) && StringUtils.isNotBlank((String)this.authenticationProxy.getSecurity().getKeyStoreAliasPassword()) && StringUtils.isNotBlank((String)this.authenticationProxy.getSecurity().getKeyStoreFile()) && StringUtils.isNotBlank((String)this.authenticationProxy.getSecurity().getKeyStorePassword()) && StringUtils.isNotBlank((String)this.authenticationProxy.getSecurity().getTrustStoreFile()) && this.authenticationProxy.getEndpoint() != null;
    }

    protected abstract boolean send(Collection<T> var1);

    protected boolean canHandle(T metrics) {
        return true;
    }

    protected boolean flush(Collection<T> collection) {
        return this.send(collection);
    }

    protected boolean isSuccessStatusCode(int statusCode) {
        return Response.Status.Family.familyOf((int)statusCode) == Response.Status.Family.SUCCESSFUL;
    }
}

