/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.monitoring.publisher.ingest;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.NotAvailableOn;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.domain.monitoring.ApplicationMetrics;
import com.mulesoft.agent.domain.monitoring.FlowMetrics;
import com.mulesoft.agent.domain.monitoring.GroupedApplicationsMetrics;
import com.mulesoft.agent.domain.monitoring.Metric;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.monitoring.publisher.ingest.IngestMonitorPublisher;
import com.mulesoft.agent.monitoring.publisher.ingest.builder.IngestApplicationMetricPostBodyBuilder;
import com.mulesoft.agent.monitoring.publisher.ingest.builder.IngestMetricBuilder;
import com.mulesoft.agent.monitoring.publisher.ingest.model.DefaultMetricSample;
import com.mulesoft.agent.monitoring.publisher.ingest.model.MetricClassification;
import com.mulesoft.agent.monitoring.publisher.ingest.model.api.IngestApplicationMetricPostBody;
import com.mulesoft.agent.monitoring.publisher.ingest.model.api.IngestFlowMetrics;
import com.mulesoft.agent.monitoring.publisher.ingest.model.api.IngestMetric;
import com.mulesoft.agent.services.OnOffSwitch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.Response;

@Singleton
@Named(value="mule.agent.ingest.application.metrics.internal.handler")
@NotAvailableOn(environment={RuntimeEnvironment.ON_PREM, RuntimeEnvironment.STANDALONE})
public class IngestApplicationMonitorPublisher
extends IngestMonitorPublisher<GroupedApplicationsMetrics> {
    private static final Logger LOGGER = LogManager.getLogger(IngestApplicationMonitorPublisher.class);
    private static final String MESSAGE_COUNT_NAME = "messageCount";
    private static final String RESPONSE_TIME_NAME = "responseTime";
    private static final String ERROR_COUNT_NAME = "errorCount";
    private static final List<String> KEYS = Lists.newArrayList((Object[])new String[]{"messageCount", "responseTime", "errorCount"});
    @Configurable(value="10000")
    private Long applicationPublishTimeOut;
    @Configurable(value="MILLISECONDS")
    private TimeUnit applicationPublishTimeUnit;
    @Configurable(value="true")
    private Boolean enabled;
    @Inject
    private IngestApplicationMetricPostBodyBuilder appMetricBuilder;
    @Inject
    private IngestMetricBuilder metricBuilder;
    private ExecutorService executor;

    @Override
    @PostConfigure
    public void postConfigurable() throws AgentEnableOperationException {
        if (this.enabledSwitch == null) {
            this.enabledSwitch = OnOffSwitch.newNullSwitch((boolean)this.enabled);
        }
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setPriority(1).setNameFormat("monitoring-application-publisher-%d").build();
        this.executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), threadFactory);
    }

    private Map<String, IngestFlowMetrics> extractFlowMetrics(ApplicationMetrics applicationMetrics) {
        HashMap result = Maps.newHashMap();
        for (Map.Entry entry : applicationMetrics.getFlowMetrics().entrySet()) {
            FlowMetrics metrics = (FlowMetrics)entry.getValue();
            MetricClassification classification = new MetricClassification(KEYS, metrics.getMetrics());
            List<Metric> messageCountMetrics = classification.getMetrics(MESSAGE_COUNT_NAME);
            List<Metric> responseTimeMetrics = classification.getMetrics(RESPONSE_TIME_NAME);
            List<Metric> errorCountMetrics = classification.getMetrics(ERROR_COUNT_NAME);
            IngestMetric messageCountSample = this.metricBuilder.build(new DefaultMetricSample(messageCountMetrics));
            HashSet messageCount = messageCountMetrics != null && messageCountMetrics.size() > 0 ? Sets.newHashSet((Object[])new IngestMetric[]{messageCountSample}) : Sets.newHashSet();
            boolean avgMessageCountIsNotZero = messageCountSample.getAvg() != 0.0;
            HashSet responseTime = responseTimeMetrics != null && responseTimeMetrics.size() > 0 && avgMessageCountIsNotZero ? Sets.newHashSet((Object[])new IngestMetric[]{this.metricBuilder.build(new DefaultMetricSample(responseTimeMetrics))}) : Sets.newHashSet();
            HashSet errorCount = errorCountMetrics != null && errorCountMetrics.size() > 0 && avgMessageCountIsNotZero ? Sets.newHashSet((Object[])new IngestMetric[]{this.metricBuilder.build(new DefaultMetricSample(errorCountMetrics))}) : Sets.newHashSet();
            result.put(entry.getKey(), new IngestFlowMetrics(messageCount, responseTime, errorCount));
        }
        return result;
    }

    private Map<String, IngestApplicationMetricPostBody> processApplicationMetrics(Collection<GroupedApplicationsMetrics> collection) {
        HashMap bodyByApplicationName = Maps.newHashMap();
        for (GroupedApplicationsMetrics metrics : collection) {
            for (ApplicationMetrics appMetrics : metrics.getMetricsByApplicationName().values()) {
                IngestApplicationMetricPostBody body;
                String applicationName = appMetrics.getApplicationName();
                List applicationMetrics = appMetrics.getMetrics();
                LOGGER.debug("Processing " + applicationMetrics.size() + " metrics for " + applicationName);
                MetricClassification classification = new MetricClassification(KEYS, applicationMetrics);
                List<Metric> messageCountMetrics = classification.getMetrics(MESSAGE_COUNT_NAME);
                List<Metric> responseTimeMetrics = classification.getMetrics(RESPONSE_TIME_NAME);
                List<Metric> errorCountMetrics = classification.getMetrics(ERROR_COUNT_NAME);
                IngestMetric messageCountSample = this.metricBuilder.build(new DefaultMetricSample(messageCountMetrics));
                HashSet messageCount = messageCountMetrics != null && messageCountMetrics.size() > 0 ? Sets.newHashSet((Object[])new IngestMetric[]{messageCountSample}) : Sets.newHashSet();
                boolean avgMessageCountIsNotZero = messageCountSample.getAvg() != 0.0;
                HashSet responseTime = responseTimeMetrics != null && responseTimeMetrics.size() > 0 && avgMessageCountIsNotZero ? Sets.newHashSet((Object[])new IngestMetric[]{this.metricBuilder.build(new DefaultMetricSample(responseTimeMetrics))}) : Sets.newHashSet();
                HashSet errorCount = errorCountMetrics != null && errorCountMetrics.size() > 0 && avgMessageCountIsNotZero ? Sets.newHashSet((Object[])new IngestMetric[]{this.metricBuilder.build(new DefaultMetricSample(errorCountMetrics))}) : Sets.newHashSet();
                Map<String, IngestFlowMetrics> flows = this.extractFlowMetrics(appMetrics);
                if (bodyByApplicationName.get(applicationName) == null) {
                    body = this.appMetricBuilder.build(messageCount, responseTime, errorCount, flows);
                    bodyByApplicationName.put(applicationName, body);
                    continue;
                }
                body = (IngestApplicationMetricPostBody)bodyByApplicationName.get(applicationName);
                body.getMessageCount().addAll(messageCount);
                body.getResponseTime().addAll(responseTime);
                body.getErrorCount().addAll(errorCount);
                if (body.getFlows().isEmpty()) {
                    body.setFlows(flows);
                    continue;
                }
                for (Map.Entry<String, IngestFlowMetrics> entry : flows.entrySet()) {
                    IngestFlowMetrics justFound = entry.getValue();
                    IngestFlowMetrics existing = body.getFlows().get(entry.getKey());
                    if (existing == null) {
                        body.getFlows().put(entry.getKey(), justFound);
                        continue;
                    }
                    existing.getMessageCount().addAll(justFound.getMessageCount());
                    existing.getResponseTime().addAll(justFound.getResponseTime());
                    existing.getErrorCount().addAll(justFound.getErrorCount());
                }
            }
        }
        return bodyByApplicationName;
    }

    @Override
    protected boolean send(Collection<GroupedApplicationsMetrics> collection) {
        LOGGER.debug("Publishing application metrics to ingest api.");
        try {
            ArrayList futures = new ArrayList();
            Map<String, IngestApplicationMetricPostBody> metrics = this.processApplicationMetrics(collection);
            final CountDownLatch latch = new CountDownLatch(metrics.size());
            final List statusCodes = Collections.synchronizedList(Lists.newLinkedList());
            for (Map.Entry<String, IngestApplicationMetricPostBody> entry : metrics.entrySet()) {
                final String applicationName = entry.getKey();
                final IngestApplicationMetricPostBody ingestApplicationMetricPostBody = entry.getValue();
                Future<?> future = this.executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Response httpResponse = IngestApplicationMonitorPublisher.this.client.postApplicationMetrics(applicationName, ingestApplicationMetricPostBody);
                            if (IngestApplicationMonitorPublisher.this.isSuccessStatusCode(httpResponse.getStatusCode())) {
                                LOGGER.debug("Successfully published application metrics for " + applicationName);
                            } else {
                                LOGGER.warn("Could not publish app metrics for " + applicationName + " to Ingest.");
                            }
                            statusCodes.add(httpResponse.getStatusCode());
                        }
                        catch (Exception e) {
                            LOGGER.warn(String.format("Could not publish application metrics for %s, cause: %s", applicationName, e.getMessage()));
                            LOGGER.debug("Error: ", (Throwable)e);
                            statusCodes.add(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
                futures.add(future);
            }
            boolean latchResult = latch.await(this.applicationPublishTimeOut, this.applicationPublishTimeUnit);
            boolean successful = true;
            if (!latchResult) {
                successful = false;
                LOGGER.warn("Timeout occurred while publishing application metrics. Please try increasing the applicationPublishTimeOut to see if it fixes the problem.");
                for (Future future : futures) {
                    if (future.isDone()) continue;
                    future.cancel(true);
                }
            }
            Iterator<Object> iterator = statusCodes.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                if (this.isSuccessStatusCode(n)) continue;
                successful = false;
            }
            if (successful) {
                LOGGER.debug("Published app metrics to Ingest successfully");
            } else {
                LOGGER.warn("Some metrics for applications could not be published.");
            }
            return successful;
        }
        catch (Exception e) {
            LOGGER.warn(String.format("Could not publish application metrics to Ingest, cause: %s", e.getMessage()));
            LOGGER.debug("Error: ", (Throwable)e);
            return false;
        }
    }
}

