/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.pricing.collector;

import org.mule.metrics.api.meter.Meter;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.collector.PricingStatsCollector;
import org.mule.ubp.meter.commons.components.MeteringComponents;
import org.mule.ubp.meter.commons.pricing.sampler.PricingStatsCollectorSampler;

public class CommonPricingStatsCollector
implements PricingStatsCollector {
    private final Meter meter;
    private PricingStatsCollectorSampler pricingStatsCollectorSampler;

    public CommonPricingStatsCollector(PricingStatsCollectorSampler pricingStatsCollectorSampler, CollectorRegistry collectorRegistry) {
        this(pricingStatsCollectorSampler, collectorRegistry, MeteringComponents.getPricingMeter(collectorRegistry));
    }

    public CommonPricingStatsCollector(PricingStatsCollectorSampler pricingStatsCollectorSampler, CollectorRegistry collectorRegistry, Meter meter) {
        this.pricingStatsCollectorSampler = pricingStatsCollectorSampler;
        this.meter = meter;
    }

    private void registerMetrics(PricingStatsCollectorSampler pricingStatsCollectorSampler) {
        this.meter.counterBuilder("mulesoft.runtime.invocation_usage.usage_count").withValueSupplier(pricingStatsCollectorSampler::getUsageCount).withDescription("Usage Count").withUnit("times").build();
        this.meter.counterBuilder("mulesoft.runtime.invocation_usage.public_usage_count").withValueSupplier(pricingStatsCollectorSampler::getPublicUsage).withDescription("Public Usage Count").withUnit("times").build();
        this.meter.gaugeBuilder("mulesoft.runtime.invocation_usage.flow_count").withValueSupplier(pricingStatsCollectorSampler::getFlowCount).withDescription("Flow Count").withUnit("times").build();
    }

    public void startCollection() {
        this.registerMetrics(this.pricingStatsCollectorSampler);
    }

    public void stopCollection() {
    }
}

