/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.pricing.builder;

import java.util.function.Supplier;
import org.mule.metrics.api.meter.Meter;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.collector.PricingStatsCollector;
import org.mule.ubp.meter.api.collector.builder.PricingStatsCollectorBuilder;
import org.mule.ubp.meter.commons.pricing.collector.CommonPricingStatsCollector;
import org.mule.ubp.meter.commons.pricing.sampler.SupplierBasedPricingStatsCollectorSampler;

public class CommonPricingStatsCollectorBuilder
implements PricingStatsCollectorBuilder {
    public static final String A_PUBLIC_USAGE_SUPPLIER_WAS_NOT_SET_ERROR_MESSAGE = "A public usage supplier was not set";
    public static final String A_FLOW_COUNT_SUPPLIER_WAS_NOT_SET_ERROR_MESSAGE = "A flow count supplier was not set";
    public static final String USAGE_COUNT_SUPPLIER_WAS_NOT_SET_ERROR_MESSAGE = "Usage count supplier was not set";
    public static final String THE_COLLECTOR_REGISTRY_WAS_NOT_SET = "the collector registry not set";
    private Supplier<Long> usageCountSupplier;
    private Supplier<Long> flowCountSupplier;
    private Supplier<Long> publicUsageSupplier;
    private CollectorRegistry collectorRegistry;
    private Meter meter;

    private CommonPricingStatsCollectorBuilder() {
    }

    public static CommonPricingStatsCollectorBuilder commonPricingCollectorBuilder() {
        return new CommonPricingStatsCollectorBuilder();
    }

    public CommonPricingStatsCollectorBuilder withUsageCountSupplier(Supplier<Long> usageCountSupplier) {
        this.usageCountSupplier = usageCountSupplier;
        return this;
    }

    public CommonPricingStatsCollectorBuilder withFlowCountSupplier(Supplier<Long> flowCountSupplier) {
        this.flowCountSupplier = flowCountSupplier;
        return this;
    }

    public CommonPricingStatsCollectorBuilder withPublicUsageSupplier(Supplier<Long> publicUsageSupplier) {
        this.publicUsageSupplier = publicUsageSupplier;
        return this;
    }

    public CommonPricingStatsCollectorBuilder withCollectorRegistry(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
        return this;
    }

    public CommonPricingStatsCollectorBuilder withMeter(Meter meter) {
        this.meter = meter;
        return this;
    }

    public PricingStatsCollector build() {
        this.assertBuildParameters();
        if (this.meter == null) {
            return new CommonPricingStatsCollector(new SupplierBasedPricingStatsCollectorSampler(this.usageCountSupplier, this.flowCountSupplier, this.publicUsageSupplier), this.collectorRegistry);
        }
        return new CommonPricingStatsCollector(new SupplierBasedPricingStatsCollectorSampler(this.usageCountSupplier, this.flowCountSupplier, this.publicUsageSupplier), this.collectorRegistry, this.meter);
    }

    private void assertBuildParameters() {
        if (this.publicUsageSupplier == null) {
            throw new IllegalArgumentException(A_PUBLIC_USAGE_SUPPLIER_WAS_NOT_SET_ERROR_MESSAGE);
        }
        if (this.flowCountSupplier == null) {
            throw new IllegalArgumentException(A_FLOW_COUNT_SUPPLIER_WAS_NOT_SET_ERROR_MESSAGE);
        }
        if (this.usageCountSupplier == null) {
            throw new IllegalArgumentException(USAGE_COUNT_SUPPLIER_WAS_NOT_SET_ERROR_MESSAGE);
        }
        if (this.collectorRegistry == null) {
            throw new IllegalArgumentException(THE_COLLECTOR_REGISTRY_WAS_NOT_SET);
        }
    }
}

