/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.pricing;

import java.util.function.Supplier;
import org.mule.metrics.api.meter.Meter;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.management.stats.FlowsSummaryStatistics;
import org.mule.runtime.core.api.management.stats.ResetOnQueryCounter;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.collector.PricingStatsCollector;
import org.mule.ubp.meter.commons.pricing.builder.CommonPricingStatsCollectorBuilder;

public class PricingCollectorProvider {
    public PricingStatsCollector pricingStatsCollector(AllStatistics allStatistics, CollectorRegistry collectorRegistry, Meter meter) {
        return this.getCommonPricingStatsCollectorBuilder(allStatistics, collectorRegistry).withCollectorRegistry(collectorRegistry).withMeter(meter).build();
    }

    public PricingStatsCollector pricingStatsCollector(AllStatistics allStatistics, CollectorRegistry collectorRegistry) {
        return this.getCommonPricingStatsCollectorBuilder(allStatistics, collectorRegistry).withCollectorRegistry(collectorRegistry).build();
    }

    private CommonPricingStatsCollectorBuilder getCommonPricingStatsCollectorBuilder(AllStatistics allStatistics, CollectorRegistry collectorRegistry) {
        return CommonPricingStatsCollectorBuilder.commonPricingCollectorBuilder().withFlowCountSupplier((Supplier)this.getFlowCounterSupplier(allStatistics)).withPublicUsageSupplier((Supplier)this.getPublicUsageSupplier(allStatistics)).withUsageCountSupplier((Supplier)this.getUsageCountSupplier(allStatistics)).withCollectorRegistry(collectorRegistry);
    }

    private Supplier<Long> getUsageCountSupplier(AllStatistics allStatistics) {
        FlowConstructStatistics appStats = allStatistics.getApplicationStatistics();
        ResetOnQueryCounter resetOnQueryCounter = appStats.getEventsReceivedCounter();
        return () -> resetOnQueryCounter.get();
    }

    private Supplier<Long> getPublicUsageSupplier(AllStatistics allStatistics) {
        FlowConstructStatistics appStats = allStatistics.getApplicationStatistics();
        ResetOnQueryCounter resetOnQueryCounter = appStats.getDispatchedMessagesCounter();
        return () -> resetOnQueryCounter.get();
    }

    private Supplier<Long> getFlowCounterSupplier(AllStatistics allStatistics) {
        FlowsSummaryStatistics flowsSummaryStatistics = allStatistics.getFlowSummaryStatistics();
        return () -> flowsSummaryStatistics.getDeclaredTriggerFlows() + flowsSummaryStatistics.getDeclaredApikitFlows();
    }
}

