/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.cores.utils;

import java.util.HashMap;
import java.util.Map;
import org.mule.ubp.meter.commons.cores.collector.utils.CommonCoreCountUtils;
import org.mule.ubp.meter.commons.cores.collector.vm.DetectVM;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;

public class CoreCounterUtils {
    private static final CentralProcessor CPU = new SystemInfo().getHardware().getProcessor();

    public static Long getLogicalProcessorCount() {
        return CPU.getLogicalProcessorCount();
    }

    public static Long getAllocatedLogicalCores() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static Map<String, String> getFingerPrintingAttributes() {
        HashMap<String, String> meterAttributes = new HashMap<String, String>();
        meterAttributes.put("mulesoft.host.id", CommonCoreCountUtils.getHfFingerPrint());
        return meterAttributes;
    }

    public static Map<String, String> getTroubleshootingAttributes() {
        HashMap<String, String> troubleshootingAttributes = new HashMap<String, String>();
        troubleshootingAttributes.put("mulesoft.java.version", CommonCoreCountUtils.getJavaVersion());
        troubleshootingAttributes.put("mulesoft.os.name", CommonCoreCountUtils.getOs());
        troubleshootingAttributes.put("mulesoft.host.docker_detected", CommonCoreCountUtils.isDockerDetected());
        troubleshootingAttributes.put("mulesoft.host.vm_type", DetectVM.identifyVM());
        return troubleshootingAttributes;
    }
}

