/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.cores.collector.vm;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.mule.ubp.meter.commons.cores.collector.vm.AwsEnvironmentPropertyBasedDetector;
import org.mule.ubp.meter.commons.cores.collector.vm.AzureEnvironmentPropertyBasedDetector;
import org.mule.ubp.meter.commons.cores.collector.vm.CompositeEnvironmentPropertyBasedDetector;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.util.FileUtil;

public class DetectVM {
    private static final String OSHI_VM_MAC_ADDR_PROPERTIES = "oshi.vmmacaddr.properties";
    private static final Properties vmMacAddressProps = FileUtil.readPropertiesFromFilename((String)"oshi.vmmacaddr.properties");
    private static final Map<String, String> vmVendor = new HashMap<String, String>();
    public static final String MICROSOFT_CORPORATION = "Microsoft Corporation";
    public static final String VIRTUAL_MACHINE = "Virtual Machine";
    public static final String MICROSOFT_HYPER_V = "Microsoft Hyper-V";
    private static final String[] vmModelArray;

    public static String identifyVM() {
        return new DetectVM().hypervisor();
    }

    private DetectVM() {
    }

    public String hypervisor() {
        SystemInfo si = new SystemInfo();
        HardwareAbstractionLayer hw = si.getHardware();
        String vmByEnvironmentProperty = new CompositeEnvironmentPropertyBasedDetector(new AzureEnvironmentPropertyBasedDetector(), new AwsEnvironmentPropertyBasedDetector()).detect();
        if (vmByEnvironmentProperty != null) {
            return vmByEnvironmentProperty;
        }
        String vendor = hw.getProcessor().getProcessorIdentifier().getVendor().trim();
        if (vmVendor.containsKey(vendor)) {
            return vmVendor.get(vendor);
        }
        List nifs = hw.getNetworkIFs();
        for (String[] nif : nifs) {
            String mac = nif.getMacaddr().toUpperCase(Locale.ROOT);
            String oui = mac.length() > 7 ? mac.substring(0, 8) : mac;
            if (!vmMacAddressProps.containsKey(oui)) continue;
            return vmMacAddressProps.getProperty(oui);
        }
        String model = hw.getComputerSystem().getModel();
        for (String vm : vmModelArray) {
            if (!model.contains(vm)) continue;
            return vm;
        }
        String manufacturer = hw.getComputerSystem().getManufacturer();
        if (MICROSOFT_CORPORATION.equals(manufacturer) && VIRTUAL_MACHINE.equals(model)) {
            return MICROSOFT_HYPER_V;
        }
        return "UNKNOWN_TYPE_DETECTED";
    }

    static {
        vmVendor.put("bhyve bhyve", "bhyve");
        vmVendor.put("KVMKVMKVM", "KVM");
        vmVendor.put("TCGTCGTCGTCG", "QEMU");
        vmVendor.put("Microsoft Hv", "Microsoft Hyper-V or Windows Virtual PC");
        vmVendor.put("lrpepyh vr", "Parallels");
        vmVendor.put("VMwareVMware", "VMware");
        vmVendor.put("XenVMMXenVMM", "Xen HVM");
        vmVendor.put("ACRNACRNACRN", "Project ACRN");
        vmVendor.put("QNXQVMBSQG", "QNX Hypervisor");
        vmModelArray = new String[]{"Linux KVM", "Linux lguest", "OpenVZ", "Qemu", "Microsoft Virtual PC", "VMWare", "linux-vserver", "Xen", "FreeBSD Jail", "VirtualBox", "Parallels", "Linux Containers", "LXC"};
    }
}

