/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.cores.collector.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.jacoco.agent.rt.internal_b6258fc.core.internal.data.CRC64;
import org.mule.ubp.meter.commons.cores.utils.CoreCounterUtils;
import oshi.SystemInfo;
import oshi.hardware.ComputerSystem;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;

public class CommonCoreCountUtils {
    private static final String MULESOFT_PREFIX = "mulesoft.";
    private static final String HOST_PREFIX = "mulesoft.host.";
    public static final String NAMESPACE = "mulesoft.runtime.core_count.";
    public static final String ALLOCATED_LOGICAL_CORES = "mulesoft.runtime.core_count.allocated_logical_cores";
    public static final String LOGICAL_CORES = "mulesoft.runtime.core_count.logical_cores";
    public static final String ALLOCATED_LOGICAL_CORES_DESCRIPTION = "Allocated Logical Cores";
    public static final String UNIT = "cores";
    public static final String LOGICAL_CORES_DESCRIPTION = "Logical Cores";
    public static final String NOT_RETRIEVABLE = "not_retrievable";
    public static final String JAVA_VERSION = "mulesoft.java.version";
    public static final String OPERATING_SYSTEM = "mulesoft.os.name";
    public static final String DOCKER_DETECTED = "mulesoft.host.docker_detected";
    public static final String HF_FINGER_PRINT = "mulesoft.host.id";
    public static final String DETECTED_VM_HYPERVISOR = "mulesoft.host.vm_type";

    private CommonCoreCountUtils() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String isDockerDetected() {
        if (Files.exists(Paths.get("/.dockerenv", new String[0]), new LinkOption[0])) {
            return "true";
        }
        try (Stream<String> stream = Files.lines(Paths.get("/proc/1/cgroup", new String[0]));){
            String string = "" + stream.anyMatch(line -> line.contains("/docker"));
            return string;
        }
        catch (IOException e) {
            return "false";
        }
    }

    public static String getOs() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    public static String getHfFingerPrint() {
        HardwareAbstractionLayer hardware = new SystemInfo().getHardware();
        ComputerSystem computerSystem = hardware.getComputerSystem();
        String hwManufacturer = computerSystem.getManufacturer().toLowerCase();
        String hwSerial = computerSystem.getSerialNumber().toLowerCase();
        String hwUUID = computerSystem.getHardwareUUID().toLowerCase();
        String hwFirmware = computerSystem.getFirmware().toString().toLowerCase();
        String hwModel = computerSystem.getModel().toLowerCase();
        String hwBaseBoard = computerSystem.getBaseboard().toString().toLowerCase();
        String data = Arrays.toString(hardware.getNetworkIFs().stream().map(NetworkIF::getMacaddr).toArray()) + hwManufacturer + hwSerial + hwUUID + hwFirmware + hwModel + hwBaseBoard;
        return Long.toHexString(CRC64.classId((byte[])data.getBytes()));
    }

    public static Map<String, String> resolveMeterAttributes(boolean fingerPrinting, boolean troubleshooting) {
        HashMap<String, String> resolvedAttributes = new HashMap<String, String>();
        if (fingerPrinting) {
            resolvedAttributes.putAll(CoreCounterUtils.getFingerPrintingAttributes());
        }
        if (troubleshooting) {
            resolvedAttributes.putAll(CoreCounterUtils.getTroubleshootingAttributes());
        }
        return resolvedAttributes;
    }
}

