/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.cores.builder;

import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.mule.metrics.api.meter.Meter;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.collector.PricingStatsCollector;
import org.mule.ubp.meter.api.collector.builder.CoreCountCollectorBuilder;
import org.mule.ubp.meter.commons.components.MeteringComponents;
import org.mule.ubp.meter.commons.cores.collector.CommonCoreCountStatsCollector;
import org.mule.ubp.meter.commons.cores.collector.utils.CommonCoreCountUtils;
import org.mule.ubp.meter.commons.cores.sampler.CommonCoreCountSampler;

public class CommonCoreCountCollectorBuilder
implements CoreCountCollectorBuilder {
    public static final String AN_ALLOCATED_LOGICAL_CORES_SUPPLIER_WAS_NOT_SET = "An allocated logical cores supplier was not set";
    public static final String A_LOGICAL_CORES_SUPPLIER_WAS_NOT_SET = "A logical cores supplier was not set";
    public static final String THE_CONTEXT_PARAMETERS_WERE_NOT_SET = "the collector registry was not set";
    private Supplier<Long> allocatedLogicalCoresSupplier;
    private Supplier<Long> logicalCoresSupplier;
    private CollectorRegistry collectorRegistry;
    private Meter meter;
    private boolean fingerPrinting = true;
    private boolean troubleshooting = true;
    private BiFunction<CollectorRegistry, Map<String, String>, Meter> meterGetter = MeteringComponents::getPricingMeter;

    public CommonCoreCountCollectorBuilder withAllocatedLogicalCoresSupplier(Supplier<Long> allocatedLogicalCoresSupplier) {
        this.allocatedLogicalCoresSupplier = allocatedLogicalCoresSupplier;
        return this;
    }

    public CommonCoreCountCollectorBuilder withLogicalCoresSupplier(Supplier<Long> logicalCoresSupplier) {
        this.logicalCoresSupplier = logicalCoresSupplier;
        return this;
    }

    public CommonCoreCountCollectorBuilder withCollectorRegistry(CollectorRegistry collectorRegistry) {
        this.collectorRegistry = collectorRegistry;
        return this;
    }

    public CommonCoreCountCollectorBuilder withFingerPrintingAttributes(boolean fingerPrinting) {
        this.fingerPrinting = fingerPrinting;
        return this;
    }

    public CommonCoreCountCollectorBuilder withTroubleshootingAttributes(boolean troubleshooting) {
        this.troubleshooting = troubleshooting;
        return this;
    }

    public CommonCoreCountCollectorBuilder withMeter(Meter meter) {
        this.meter = meter;
        return this;
    }

    public CommonCoreCountCollectorBuilder withMeterGetter(BiFunction<CollectorRegistry, Map<String, String>, Meter> meterGetter) {
        this.meterGetter = meterGetter;
        return this;
    }

    public PricingStatsCollector build() {
        this.assertBuildParameters();
        return new CommonCoreCountStatsCollector(new CommonCoreCountSampler(this.allocatedLogicalCoresSupplier, this.logicalCoresSupplier), Optional.ofNullable(this.meter).orElse(this.meterGetter.apply(this.collectorRegistry, CommonCoreCountUtils.resolveMeterAttributes(this.fingerPrinting, this.troubleshooting))));
    }

    private void assertBuildParameters() {
        if (this.allocatedLogicalCoresSupplier == null) {
            throw new IllegalArgumentException(AN_ALLOCATED_LOGICAL_CORES_SUPPLIER_WAS_NOT_SET);
        }
        if (this.logicalCoresSupplier == null) {
            throw new IllegalArgumentException(A_LOGICAL_CORES_SUPPLIER_WAS_NOT_SET);
        }
        if (this.collectorRegistry == null) {
            throw new IllegalArgumentException(THE_CONTEXT_PARAMETERS_WERE_NOT_SET);
        }
    }
}

