/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ubp.meter.commons.cores;

import org.mule.metrics.api.meter.Meter;
import org.mule.ubp.meter.api.collector.CollectorRegistry;
import org.mule.ubp.meter.api.collector.PricingStatsCollector;
import org.mule.ubp.meter.commons.cores.builder.CommonCoreCountCollectorBuilder;
import org.mule.ubp.meter.commons.cores.utils.CoreCounterUtils;

public class CoreCountCollectorProvider {
    public static final String CORE_COUNT_TROUBLESHOOTING = "core_count_troubleshooting";
    public static final String CORE_COUNT_FINGER_PRINTING = "core_count_fingerprinting";

    public PricingStatsCollector get(CollectorRegistry collectorRegistry) {
        return this.get(collectorRegistry, null);
    }

    public PricingStatsCollector get(CollectorRegistry collectorRegistry, Meter meter) {
        CommonCoreCountCollectorBuilder collectorBuilder = new CommonCoreCountCollectorBuilder();
        if (meter != null) {
            collectorBuilder.withMeter(meter);
        }
        Boolean troubleshooting = (Boolean)collectorRegistry.get(CORE_COUNT_TROUBLESHOOTING);
        Boolean fingerPrinting = (Boolean)collectorRegistry.get(CORE_COUNT_FINGER_PRINTING);
        if (troubleshooting == null) {
            troubleshooting = true;
        }
        if (fingerPrinting == null) {
            fingerPrinting = true;
        }
        return collectorBuilder.withCollectorRegistry(collectorRegistry).withLogicalCoresSupplier(CoreCounterUtils::getLogicalProcessorCount).withAllocatedLogicalCoresSupplier(CoreCounterUtils::getAllocatedLogicalCores).withTroubleshootingAttributes(troubleshooting).withFingerPrintingAttributes(fingerPrinting).build();
    }
}

