/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty.frame;

import com.mulesoft.service.http.impl.netty.frame.NettyWebSocketFrame;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import org.mule.runtime.api.util.LazyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketFramesHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketFramesHandler.class);
    private final LazyValue<ExecutorService> schedulerToCompleteWhenNonFinal;
    private final Consumer<NettyWebSocketFrame> onFirstFrame;
    private OutputStream sinkForContinuationFrames;

    public WebSocketFramesHandler(LazyValue<ExecutorService> schedulerToCompleteWhenNonFinal, Consumer<NettyWebSocketFrame> onFirstFrame) {
        this.schedulerToCompleteWhenNonFinal = schedulerToCompleteWhenNonFinal;
        this.onFirstFrame = onFirstFrame;
    }

    public void onFrame(WebSocketFrame webSocketFrame) throws IOException {
        LOGGER.debug("Received frame type={}, final={}", (Object)webSocketFrame.getClass().getName(), (Object)webSocketFrame.isFinalFragment());
        if (webSocketFrame instanceof ContinuationWebSocketFrame) {
            if (this.sinkForContinuationFrames == null) {
                throw new IllegalStateException("Received a continuation frame, but there is no sink where we can write it");
            }
            byte[] bytes = ByteBufUtil.getBytes((ByteBuf)webSocketFrame.content());
            this.sinkForContinuationFrames.write(bytes);
            if (webSocketFrame.isFinalFragment()) {
                this.closeContinuationsSink();
            }
            return;
        }
        NettyWebSocketFrame adaptedFrame = new NettyWebSocketFrame(webSocketFrame, null);
        this.sinkForContinuationFrames = adaptedFrame.getSinkForContinuation().orElse(null);
        if (webSocketFrame.isFinalFragment()) {
            this.onFirstFrame.accept(adaptedFrame);
            return;
        }
        try {
            ((ExecutorService)this.schedulerToCompleteWhenNonFinal.get()).submit(() -> this.onFirstFrame.accept(adaptedFrame));
        }
        catch (RejectedExecutionException ree) {
            LOGGER.warn("Couldn't schedule task to handle first websocket frame. Handling it synchronously. This may result in a blocked thread if the payload consumer is executed inside the callback", (Throwable)ree);
            this.onFirstFrame.accept(adaptedFrame);
        }
    }

    public void cancel() throws IOException {
        this.closeContinuationsSink();
    }

    private void closeContinuationsSink() throws IOException {
        if (this.sinkForContinuationFrames != null) {
            LOGGER.debug("Closing continuation frames sink");
            this.sinkForContinuationFrames.close();
            this.sinkForContinuationFrames = null;
        }
    }
}

