/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import com.mulesoft.service.http.impl.netty.ForwardingToWsListenerHandler;
import com.mulesoft.service.http.impl.netty.MuleWebSocketServerProtocolHandler;
import com.mulesoft.service.http.impl.netty.NettyWebSocketRequest;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.http.api.domain.request.HttpRequestContext;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.async.HttpResponseReadyCallback;
import org.mule.runtime.http.api.server.ws.WebSocketHandler;
import org.mule.runtime.http.api.utils.RequestMatcherRegistry;
import org.mule.service.http.netty.impl.message.NettyHttpRequestAdapter;
import org.mule.service.http.netty.impl.server.NettyHttp1ResponseReadyCallback;
import org.mule.service.http.netty.impl.server.NettyHttpRequestContext;
import org.mule.service.http.netty.impl.server.util.ServiceTemporarilyUnavailableListenerRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketServerPipelineUpgrader
extends ChannelInboundHandlerAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketServerPipelineUpgrader.class);
    public static final String NAME = "WebSocket Server Pipeline Upgrader";
    private final ServerAddress serverAddress;
    public final RequestMatcherRegistry<WebSocketHandler> webSocketsHandlersRegistry;
    private final SchedulerService schedulerService;
    private Scheduler workersScheduler = null;
    private boolean handlingUpgradeRequest;

    public WebSocketServerPipelineUpgrader(ServerAddress serverAddress, RequestMatcherRegistry<WebSocketHandler> webSocketsHandlersRegistry, SchedulerService schedulerService) {
        this.serverAddress = serverAddress;
        this.webSocketsHandlersRegistry = webSocketsHandlersRegistry;
        this.schedulerService = schedulerService;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.handlingUpgradeRequest && msg instanceof HttpContent) {
            return;
        }
        if (!(msg instanceof HttpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        HttpRequest httpRequest = (HttpRequest)msg;
        if (!this.isWebSocketUpgradeRequest(httpRequest)) {
            ctx.fireChannelRead(msg);
            return;
        }
        this.handlingUpgradeRequest = true;
        NettyHttpRequestAdapter muleRequest = new NettyHttpRequestAdapter(httpRequest, this.serverAddress, null);
        WebSocketHandler webSocketHandler = (WebSocketHandler)this.webSocketsHandlersRegistry.find((org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequest);
        if (webSocketHandler == null) {
            ServiceTemporarilyUnavailableListenerRequestHandler error503Handler = ServiceTemporarilyUnavailableListenerRequestHandler.getInstance();
            NettyHttpRequestContext requestContext = new NettyHttpRequestContext((org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequest, ctx, this.getSslHandler(ctx));
            NettyHttp1ResponseReadyCallback readyCallback = new NettyHttp1ResponseReadyCallback(ctx, (org.mule.runtime.http.api.domain.message.request.HttpRequest)muleRequest, (Executor)ctx.executor());
            error503Handler.handleRequest((HttpRequestContext)requestContext, (HttpResponseReadyCallback)readyCallback);
            return;
        }
        LOGGER.debug("Upgrading channel [{}] to handle WebSockets", (Object)ctx.channel().id().asLongText());
        ctx.pipeline().replace("Forward to HTTP Listener", "WebSocket Server Handler", (ChannelHandler)new MuleWebSocketServerProtocolHandler(MuleWebSocketServerProtocolHandler.defaultConfig()));
        long idleTimeout = webSocketHandler.getIdleSocketTimeoutMills();
        if (idleTimeout != -1L) {
            ctx.pipeline().addLast("wsIdleStateHandler", (ChannelHandler)new IdleStateHandler(idleTimeout, idleTimeout, idleTimeout, TimeUnit.MILLISECONDS));
        }
        NettyWebSocketRequest upgradeRequest = new NettyWebSocketRequest(httpRequest, this.serverAddress, ctx);
        ctx.pipeline().addLast("Forward to WS Listener", (ChannelHandler)new ForwardingToWsListenerHandler(webSocketHandler, upgradeRequest, ctx, this.lazyIoScheduler()));
        ctx.fireChannelRead(msg);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.workersScheduler != null) {
            this.workersScheduler.stop();
            this.workersScheduler = null;
        }
        ctx.fireChannelInactive();
    }

    private SslHandler getSslHandler(ChannelHandlerContext ctx) {
        return (SslHandler)ctx.pipeline().get(SslHandler.class);
    }

    private boolean isWebSocketUpgradeRequest(HttpRequest request) {
        if (!request.headers().containsValue((CharSequence)"Connection", (CharSequence)"Upgrade", true)) {
            return false;
        }
        return request.headers().containsValue((CharSequence)"Upgrade", (CharSequence)"WebSocket", true);
    }

    private LazyValue<ExecutorService> lazyIoScheduler() {
        return new LazyValue(() -> {
            this.workersScheduler = this.schedulerService.ioScheduler(SchedulerConfig.config().withName("WebSocketServerWorkers"));
            return this.workersScheduler;
        });
    }
}

