/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.service.http.impl.netty;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.net.URI;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.mule.runtime.http.api.domain.request.ClientConnection;
import org.mule.runtime.http.api.domain.request.ServerConnection;
import org.mule.runtime.http.api.server.ServerAddress;
import org.mule.runtime.http.api.server.ws.WebSocketRequest;
import org.mule.runtime.http.api.ws.WebSocketProtocol;
import org.mule.service.http.netty.impl.message.NettyHttpMessage;
import org.mule.service.http.netty.impl.server.NettyClientConnection;
import org.mule.service.http.netty.impl.server.NettyServerConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyWebSocketRequest
extends NettyHttpMessage
implements WebSocketRequest {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyWebSocketRequest.class);
    private final SslHandler sslHandler;
    private final ChannelHandlerContext ctx;
    private final WebSocketProtocol scheme;
    private String httpVersion;
    private MediaType contentType;
    private NettyServerConnection serverConnection;
    private NettyClientConnection clientConnection;

    public NettyWebSocketRequest(HttpRequest nettyRequest, ServerAddress socketAddress, ChannelHandlerContext ctx) {
        super(nettyRequest, socketAddress);
        this.sslHandler = this.getSslHandler(ctx);
        this.ctx = ctx;
        this.scheme = this.sslHandler != null ? WebSocketProtocol.WSS : WebSocketProtocol.WS;
    }

    private SslHandler getSslHandler(ChannelHandlerContext ctx) {
        return (SslHandler)ctx.pipeline().get(SslHandler.class);
    }

    protected String getBaseProtocol() {
        return this.getScheme().getScheme();
    }

    public MediaType getContentType() {
        if (this.contentType == null) {
            try {
                String nettyHeader = this.nettyRequest.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                this.contentType = nettyHeader != null ? MediaType.parse((String)nettyHeader) : MediaType.ANY;
            }
            catch (Exception e) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Received inbound WebSocket request at path {} with invalid Content-Type '{}'. Will default to '{}'", new Object[]{this.getPath(), this.contentType, MediaType.ANY.toRfcString()});
                }
                this.contentType = MediaType.ANY;
            }
        }
        return this.contentType;
    }

    public WebSocketProtocol getScheme() {
        return this.scheme;
    }

    public String getHttpVersion() {
        if (this.httpVersion == null) {
            HttpVersion nettyProtocol = this.nettyRequest.protocolVersion();
            this.httpVersion = String.format("HTTP_%d_%d", nettyProtocol.majorVersion(), nettyProtocol.minorVersion());
        }
        return this.httpVersion;
    }

    public URI getRequestUri() {
        return this.getUri();
    }

    public ServerConnection getServerConnection() {
        if (this.serverConnection == null) {
            this.serverConnection = new NettyServerConnection((InetSocketAddress)this.ctx.channel().localAddress());
        }
        return this.serverConnection;
    }

    public ClientConnection getClientConnection() {
        if (this.clientConnection == null) {
            this.clientConnection = new NettyClientConnection((InetSocketAddress)this.ctx.channel().remoteAddress(), this.sslHandler);
        }
        return this.clientConnection;
    }

    public HttpEntity getEntity() {
        return null;
    }
}

