/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats.utils;

import com.mulesoft.flatfile.lexical.formats.utils.YearValidation;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.format.ResolverStyle;
import java.time.temporal.TemporalAccessor;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.List;

public final class DateParser {
    private DateParser() {
    }

    public static LocalDateTime getDateTime(String dateTime, String format) throws DateTimeParseException {
        LocalDateTime returnLocalDateTime = LocalDateTime.from(DateParser.parseDateTime(dateTime, format));
        DateParser.doStrictValidationsOfYear(returnLocalDateTime.getYear());
        return returnLocalDateTime;
    }

    public static LocalDate getDate(String date, String format) throws DateTimeParseException {
        LocalDate returnDate = LocalDate.from(DateParser.parseDateTime(date, format));
        DateParser.doStrictValidationsOfYear(returnDate.getYear());
        return returnDate;
    }

    public static GregorianCalendar getDateAsCalendar(String date, String format) throws DateTimeParseException {
        return DateParser.getDateAsCalendar(DateParser.getDate(date, format));
    }

    public static GregorianCalendar getDateAsCalendar(LocalDate date) {
        return GregorianCalendar.from(date.atStartOfDay(ZoneId.systemDefault()));
    }

    public static LocalTime getTime(String time, String format) throws DateTimeParseException {
        return LocalTime.from(DateParser.parseDateTime(time, format));
    }

    public static TemporalAccessor resolveDateTime(String dateTime, String format) throws DateTimeParseException {
        if (DateParser.containsYear(format)) {
            if (DateParser.containsTimePattern(format)) {
                return DateParser.getDateTime(dateTime, format);
            }
            return DateParser.getDate(dateTime, format);
        }
        return DateParser.getTime(dateTime, format);
    }

    private static TemporalAccessor parseDateTime(String dateTime, String format) {
        DateTimeFormatter formatter = DateParser.getFormatter(format, ResolverStyle.STRICT);
        return formatter.parse(dateTime);
    }

    private static DateTimeFormatter getFormatter(String pattern, ResolverStyle resolverStyle) {
        return DateTimeFormatter.ofPattern(pattern).withResolverStyle(resolverStyle);
    }

    private static boolean containsYear(String pattern) {
        List<String> yearPatterns = Arrays.asList("u", "y", "Y");
        return yearPatterns.stream().anyMatch(pattern::contains);
    }

    private static boolean containsTimePattern(String pattern) {
        List<String> timePatterns = Arrays.asList("a", "h", "K", "k", "H", "m", "s", "S", "A", "n", "N");
        return timePatterns.stream().anyMatch(pattern::contains);
    }

    private static void doStrictValidationsOfYear(int year) {
        boolean strictValidationOfYear = YearValidation.getInstance().getStrictValidation();
        if (!strictValidationOfYear) {
            return;
        }
        String stringYear = String.format("%04d", year);
        if (year < 1) {
            throw new DateTimeParseException(String.format("Invalid year: \"%s\"", stringYear), stringYear, 0);
        }
    }
}

