/*
 * Decompiled with CFR 0.152.
 */
package amf.apicontract.internal.validation.shacl.graphql.values;

import amf.apicontract.internal.validation.shacl.graphql.GraphQLProperty;
import amf.apicontract.internal.validation.shacl.graphql.values.ObjectValueValidator;
import amf.apicontract.internal.validation.shacl.graphql.values.ValueValidator;
import amf.apicontract.internal.validation.shacl.graphql.values.ValueValidator$;
import amf.core.client.scala.model.domain.ArrayNode;
import amf.core.client.scala.model.domain.DataNode;
import amf.core.client.scala.model.domain.ObjectNode;
import amf.core.client.scala.model.domain.ScalarNode;
import amf.core.client.scala.model.domain.Shape;
import amf.core.client.scala.model.domain.extensions.PropertyShape;
import amf.core.internal.metamodel.Field;
import amf.core.internal.parser.domain.Annotations;
import amf.shapes.client.scala.model.domain.NodeShape;
import amf.validation.internal.shacl.custom.CustomShaclValidator;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;

public final class ObjectValueValidator$
implements ValueValidator<NodeShape> {
    public static ObjectValueValidator$ MODULE$;

    static {
        new ObjectValueValidator$();
    }

    @Override
    public boolean isNull(ScalarNode s) {
        return ValueValidator.isNull$(this, s);
    }

    @Override
    public CustomShaclValidator.ValidationInfo typeError(String expected, String actual, Annotations annotations, Field targetField) {
        return ValueValidator.typeError$(this, expected, actual, annotations, targetField);
    }

    @Override
    public Seq<CustomShaclValidator.ValidationInfo> validate(NodeShape shape, DataNode value, Field targetField) {
        boolean bl = false;
        ScalarNode scalarNode = null;
        DataNode dataNode = value;
        if (dataNode instanceof ScalarNode) {
            bl = true;
            scalarNode = (ScalarNode)dataNode;
            if (this.isNull(scalarNode)) {
                return (Seq)new .colon.colon((Object)this.typeError("object", "null", scalarNode.annotations(), targetField), (List)Nil$.MODULE$);
            }
        }
        if (bl) {
            return (Seq)new .colon.colon((Object)this.typeError("object", "scalar", scalarNode.annotations(), targetField), (List)Nil$.MODULE$);
        }
        if (dataNode instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)dataNode;
            return (Seq)new .colon.colon((Object)this.typeError("object", "list", arrayNode.annotations(), targetField), (List)Nil$.MODULE$);
        }
        if (dataNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)dataNode;
            return this.validateProperties(shape, objectNode, targetField);
        }
        throw new MatchError((Object)dataNode);
    }

    private Seq<CustomShaclValidator.ValidationInfo> validateProperties(NodeShape shape, ObjectNode value, Field targetField) {
        Map actual = value.allPropertiesWithName();
        Seq expected = shape.properties();
        ObjectValueValidator.ReportingInfo info = new ObjectValueValidator.ReportingInfo(shape.name().value(), value.annotations());
        return (Seq)this.validateExpectedProperties((Seq<PropertyShape>)expected, (Map<String, DataNode>)actual, info, targetField).$plus$plus(this.validateUnexpectedProperties((Seq<PropertyShape>)expected, (Map<String, DataNode>)actual, info, targetField), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<CustomShaclValidator.ValidationInfo> validateExpectedProperties(Seq<PropertyShape> expected, Map<String, DataNode> actual, ObjectValueValidator.ReportingInfo info, Field targetField) {
        return (Seq)expected.flatMap((Function1 & Serializable & scala.Serializable)expectedProperty -> MODULE$.validateExpectedProperty((PropertyShape)expectedProperty, actual, info, targetField), Seq$.MODULE$.canBuildFrom());
    }

    private Seq<CustomShaclValidator.ValidationInfo> validateUnexpectedProperties(Seq<PropertyShape> expected, Map<String, DataNode> actual2, ObjectValueValidator.ReportingInfo info, Field targetField) {
        Set expectedPropertyNames = ((TraversableOnce)expected.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name().value(), Seq$.MODULE$.canBuildFrom())).toSet();
        return ((TraversableOnce)((TraversableLike)actual2.keys().filter((Function1 & Serializable & scala.Serializable)actual -> BoxesRunTime.boxToBoolean((boolean)ObjectValueValidator$.$anonfun$validateUnexpectedProperties$2(expectedPropertyNames, actual)))).map((Function1 & Serializable & scala.Serializable)unexpectedProperty -> {
            String message = new StringBuilder(50).append("Unexpected property '").append((String)unexpectedProperty).append("' is not defined in object '").append(info.shapeName()).append("'").toString();
            return new CustomShaclValidator.ValidationInfo(targetField, (Option)new Some((Object)message), (Option)new Some((Object)info.annotations()));
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private Seq<CustomShaclValidator.ValidationInfo> validateExpectedProperty(PropertyShape expected, Map<String, DataNode> actual, ObjectValueValidator.ReportingInfo info, Field targetField) {
        String expectedName = expected.name().value();
        boolean bl = false;
        Option option = null;
        Option option2 = actual.get((Object)expectedName);
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            DataNode propertyValue = (DataNode)some.value();
            Shape expectedRange = expected.range();
            return ValueValidator$.MODULE$.validate(expectedRange, propertyValue, targetField);
        }
        if (None$.MODULE$.equals(option2)) {
            bl = true;
            option = option2;
            if (new GraphQLProperty(expected).isNullable()) {
                return Nil$.MODULE$;
            }
        }
        if (bl) {
            String message = new StringBuilder(51).append("Provided value for object '").append(info.shapeName()).append("' is missing property '").append(expectedName).append("'").toString();
            return (Seq)new .colon.colon((Object)new CustomShaclValidator.ValidationInfo(targetField, (Option)new Some((Object)message), (Option)new Some((Object)info.annotations())), (List)Nil$.MODULE$);
        }
        throw new MatchError((Object)option2);
    }

    public static final /* synthetic */ boolean $anonfun$validateUnexpectedProperties$2(Set expectedPropertyNames$1, String actual) {
        return !expectedPropertyNames$1.contains((Object)actual);
    }

    private ObjectValueValidator$() {
        MODULE$ = this;
        ValueValidator.$init$(this);
    }
}

