/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.eventtracking.db;

import com.fasterxml.uuid.Generators;
import com.mulesoft.agent.common.internalhandler.AbstractDBInternalHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.tooling.event.model.component.location.ComponentLocation;

@Named(value="mule.agent.tracking.handler.database")
@Singleton
public class EventTrackingDBInternalHandler
extends AbstractDBInternalHandler<AgentTrackingNotification> {
    private static final Logger LOGGER = LogManager.getLogger(EventTrackingDBInternalHandler.class);
    @Configurable(value="MULE_EVENTS")
    String eventsTable;
    @Configurable(value="MULE_EVENTS_ANNOTATIONS")
    String annotationsTable;
    @Configurable(value="MULE_EVENTS_BUSINESS")
    String businessTable;

    protected void insert(Connection connection, Collection<AgentTrackingNotification> notifications) throws SQLException {
        String insertIntoEventsTableQuery = String.format("INSERT INTO %s (id, action, application, mule_message, notification_type, path, resource_identifier, timestamp, source) VALUES (?,?,?,?,?,?,?,?,?)", this.eventsTable);
        String insertIntoAnnotationsTableQuery = String.format("INSERT INTO %s (id, event_id, annotation_type, annotation_value) VALUES (?,?,?,?)", this.annotationsTable);
        String insertIntoBusinessTableQuery = String.format("INSERT INTO %s (id, event_id, business_key, business_value) VALUES (?,?,?,?)", this.businessTable);
        try (PreparedStatement eventInsert = connection.prepareStatement(insertIntoEventsTableQuery);
             PreparedStatement annotationsInsert = connection.prepareStatement(insertIntoAnnotationsTableQuery);
             PreparedStatement businessInsert = connection.prepareStatement(insertIntoBusinessTableQuery);){
            for (AgentTrackingNotification notification : notifications) {
                LOGGER.trace("Inserting notification: " + notification);
                UUID eventId = this.insertEvent(eventInsert, notification);
                this.insertAnnotations(annotationsInsert, eventId, notification.getAnnotations());
                this.insertBusinessEvents(businessInsert, eventId, notification.getCustomEventProperties());
            }
            eventInsert.executeBatch();
            annotationsInsert.executeBatch();
            businessInsert.executeBatch();
        }
    }

    private UUID insertEvent(PreparedStatement statement, AgentTrackingNotification notification) throws SQLException {
        UUID id = Generators.timeBasedGenerator().generate();
        int parameterIndex = 1;
        statement.setString(parameterIndex++, id.toString());
        statement.setString(parameterIndex++, notification.getAction());
        statement.setString(parameterIndex++, notification.getApplication());
        statement.setString(parameterIndex++, notification.getMuleMessage());
        statement.setString(parameterIndex++, notification.getNotificationType());
        statement.setString(parameterIndex++, Optional.ofNullable(notification.getComponentLocation()).map(ComponentLocation::getLocation).orElse(null));
        statement.setString(parameterIndex++, notification.getResourceIdentifier());
        statement.setLong(parameterIndex++, notification.getTimestamp());
        statement.setString(parameterIndex, notification.getSource());
        statement.addBatch();
        return id;
    }

    private void insertAnnotations(PreparedStatement statement, UUID eventId, List<Annotation> annotations) throws SQLException {
        if (annotations == null) {
            return;
        }
        for (Annotation annotation : annotations) {
            int parameterIndex = 1;
            statement.setString(parameterIndex++, Generators.timeBasedGenerator().generate().toString());
            statement.setString(parameterIndex++, eventId.toString());
            statement.setString(parameterIndex++, annotation.annotationType().toString());
            statement.setString(parameterIndex, annotation.toString());
            statement.addBatch();
        }
    }

    private void insertBusinessEvents(PreparedStatement statement, UUID eventId, Map<String, String> businessEvents) throws SQLException {
        if (businessEvents == null) {
            return;
        }
        for (String key : businessEvents.keySet()) {
            int parameterIndex = 1;
            statement.setString(parameterIndex++, Generators.timeBasedGenerator().generate().toString());
            statement.setString(parameterIndex++, eventId.toString());
            statement.setString(parameterIndex++, key);
            statement.setString(parameterIndex, businessEvents.get(key));
            statement.addBatch();
        }
    }
}

