/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.wizard.Dialogs;
import de.schlichtherle.license.wizard.Resources;
import de.schlichtherle.swing.Defaults;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class LicensePanel
extends JPanel {
    private final LicenseManager manager;
    private LicenseContent content;
    private JTextArea consumerComponent;
    private JTextArea holderComponent;
    private JTextArea infoComponent;
    private JTextArea issuedComponent;
    private JTextArea issuerComponent;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea notAfterComponent;
    private JTextArea notBeforeComponent;
    private JTextArea subjectComponent;

    public LicensePanel(LicenseManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    public final void verify() throws Exception {
        this.content = this.manager.verify();
        this.updatePanel();
    }

    protected void updatePanel() {
        if (this.content == null) {
            return;
        }
        DateFormat format = DateFormat.getDateTimeInstance(1, 1);
        this.subjectComponent.setText(this.content.getSubject());
        this.holderComponent.setText(this.content.getHolder().getName());
        this.infoComponent.setText(this.content.getInfo());
        this.consumerComponent.setText(this.content.getConsumerType() + " (" + this.content.getConsumerAmount() + ")");
        Date notBefore = this.content.getNotBefore();
        this.notBeforeComponent.setText(notBefore != null ? format.format(notBefore) : null);
        Date notAfter = this.content.getNotAfter();
        this.notAfterComponent.setText(notAfter != null ? format.format(notAfter) : null);
        this.issuerComponent.setText(this.content.getIssuer().getName());
        Date issued = this.content.getIssued();
        this.issuedComponent.setText(issued != null ? format.format(issued) : null);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.holderComponent = new JTextArea();
        this.jLabel1 = new JLabel();
        this.subjectComponent = new JTextArea();
        this.jLabel4 = new JLabel();
        this.consumerComponent = new JTextArea();
        this.jLabel6 = new JLabel();
        this.notBeforeComponent = new JTextArea();
        this.jLabel7 = new JLabel();
        this.notAfterComponent = new JTextArea();
        this.jLabel8 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.issuerComponent = new JTextArea();
        this.jLabel9 = new JLabel();
        this.issuedComponent = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.infoComponent = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.setBorder(new CompoundBorder(new TitledBorder(null, Resources.getString("LicensePanel.title"), 0, 0, Defaults.labelBoldFont), new EmptyBorder(new Insets(10, 10, 10, 10))));
        this.jLabel2.setFont(Defaults.labelBoldFont);
        this.jLabel2.setText(Resources.getString("LicensePanel.holder.label"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jScrollPane2.setBorder(new EtchedBorder());
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jScrollPane2.setViewportBorder(null);
        this.jScrollPane2.setPreferredSize(new Dimension(300, 65));
        this.holderComponent.setEditable(false);
        this.holderComponent.setFont(Defaults.labelBoldFont);
        this.holderComponent.setLineWrap(true);
        this.holderComponent.setWrapStyleWord(true);
        this.holderComponent.setBorder(null);
        this.jScrollPane2.setViewportView(this.holderComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.jScrollPane2, gridBagConstraints);
        this.jLabel1.setText(Resources.getString("LicensePanel.subject.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jLabel1, gridBagConstraints);
        this.subjectComponent.setEditable(false);
        this.subjectComponent.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.subjectComponent, gridBagConstraints);
        this.jLabel4.setText(Resources.getString("LicensePanel.consumer.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jLabel4, gridBagConstraints);
        this.consumerComponent.setEditable(false);
        this.consumerComponent.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.consumerComponent, gridBagConstraints);
        this.jLabel6.setText(Resources.getString("LicensePanel.notBefore.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jLabel6, gridBagConstraints);
        this.notBeforeComponent.setEditable(false);
        this.notBeforeComponent.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.notBeforeComponent, gridBagConstraints);
        this.jLabel7.setFont(Defaults.labelBoldFont);
        this.jLabel7.setText(Resources.getString("LicensePanel.notAfter.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jLabel7, gridBagConstraints);
        this.notAfterComponent.setEditable(false);
        this.notAfterComponent.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.notAfterComponent, gridBagConstraints);
        this.jLabel8.setText(Resources.getString("LicensePanel.issuer.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jLabel8, gridBagConstraints);
        this.jScrollPane3.setBorder(new EtchedBorder());
        this.jScrollPane3.setHorizontalScrollBarPolicy(31);
        this.jScrollPane3.setViewportBorder(null);
        this.jScrollPane3.setPreferredSize(new Dimension(300, 65));
        this.issuerComponent.setEditable(false);
        this.issuerComponent.setLineWrap(true);
        this.issuerComponent.setWrapStyleWord(true);
        this.issuerComponent.setBorder(null);
        this.jScrollPane3.setViewportView(this.issuerComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jScrollPane3, gridBagConstraints);
        this.jLabel9.setText(Resources.getString("LicensePanel.issued.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.jLabel9, gridBagConstraints);
        this.issuedComponent.setEditable(false);
        this.issuedComponent.setBorder(new EtchedBorder());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.issuedComponent, gridBagConstraints);
        this.jLabel3.setText(Resources.getString("LicensePanel.info.label"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.ipadx = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jScrollPane1.setBorder(new EtchedBorder());
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.jScrollPane1.setViewportBorder(null);
        this.jScrollPane1.setPreferredSize(new Dimension(300, 65));
        this.infoComponent.setEditable(false);
        this.infoComponent.setLineWrap(true);
        this.infoComponent.setWrapStyleWord(true);
        this.infoComponent.setBorder(null);
        this.jScrollPane1.setViewportView(this.infoComponent);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    public static class Descriptor
    extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "LICENSE_PANEL";

        public Descriptor(LicenseManager manager) {
            super((Object)IDENTIFIER, (Component)new LicensePanel(manager));
        }

        public Object getNextPanelDescriptor() {
            return FINISH;
        }

        public Object getBackPanelDescriptor() {
            return "WELCOME_PANEL";
        }

        public void aboutToDisplayPanel() {
            LicensePanel panel = (LicensePanel)this.getPanelComponent();
            try {
                panel.verify();
            }
            catch (Exception failure) {
                Dialogs.showMessageDialog(panel, failure.getLocalizedMessage(), Resources.getString("LicensePanel.failure.title"), 0);
            }
        }
    }
}

