/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.domain.monitoring;

import com.mulesoft.agent.domain.monitoring.JMXBean;

public enum SupportedJMXBean {
    HEAP_USAGE("java.lang:type=Memory", "HeapMemoryUsage.used", "heap used"),
    HEAP_TOTAL("java.lang:type=Memory", "HeapMemoryUsage.max", "heap total"),
    HEAP_COMMITTED("java.lang:type=Memory", "HeapMemoryUsage.committed", "heap committed"),
    EDEN_USAGE("java.lang:type=MemoryPool,name=Eden Space", "Usage.used", "eden used"),
    G1_EDEN_USAGE("java.lang:type=MemoryPool,name=G1 Eden Space", "Usage.used", "g1 eden used"),
    PS_EDEN_USAGE("java.lang:type=MemoryPool,name=PS Eden Space", "Usage.used", "ps eden used"),
    PAR_EDEN_USAGE("java.lang:type=MemoryPool,name=Par Eden Space", "Usage.used", "par eden used"),
    EDEN_TOTAL("java.lang:type=MemoryPool,name=Eden Space", "Usage.max", "eden total"),
    G1_EDEN_TOTAL("java.lang:type=MemoryPool,name=G1 Eden Space", "Usage.max", "g1 eden total"),
    PS_EDEN_TOTAL("java.lang:type=MemoryPool,name=PS Eden Space", "Usage.max", "ps eden total"),
    PAR_EDEN_TOTAL("java.lang:type=MemoryPool,name=Par Eden Space", "Usage.max", "par eden total"),
    EDEN_COMMITTED("java.lang:type=MemoryPool,name=Eden Space", "Usage.committed", "eden committed"),
    G1_EDEN_COMMITTED("java.lang:type=MemoryPool,name=G1 Eden Space", "Usage.committed", "g1 eden committed"),
    PS_EDEN_COMMITTED("java.lang:type=MemoryPool,name=PS Eden Space", "Usage.committed", "ps eden committed"),
    PAR_EDEN_COMMITTED("java.lang:type=MemoryPool,name=Par Eden Space", "Usage.committed", "par eden committed"),
    SURVIVOR_USAGE("java.lang:type=MemoryPool,name=Survivor Space", "Usage.used", "survivor used"),
    G1_SURVIVOR_USAGE("java.lang:type=MemoryPool,name=G1 Survivor Space", "Usage.used", "g1 survivor used"),
    PS_SURVIVOR_USAGE("java.lang:type=MemoryPool,name=PS Survivor Space", "Usage.used", "ps survivor used"),
    PAR_SURVIVOR_USAGE("java.lang:type=MemoryPool,name=Par Survivor Space", "Usage.used", "par survivor used"),
    SURVIVOR_TOTAL("java.lang:type=MemoryPool,name=Survivor Space", "Usage.max", "survivor total"),
    G1_SURVIVOR_TOTAL("java.lang:type=MemoryPool,name=G1 Survivor Space", "Usage.max", "g1 survivor total"),
    PS_SURVIVOR_TOTAL("java.lang:type=MemoryPool,name=PS Survivor Space", "Usage.max", "ps survivor total"),
    PAR_SURVIVOR_TOTAL("java.lang:type=MemoryPool,name=Par Survivor Space", "Usage.max", "par survivor total"),
    SURVIVOR_COMMITTED("java.lang:type=MemoryPool,name=Survivor Space", "Usage.committed", "survivor committed"),
    G1_SURVIVOR_COMMITTED("java.lang:type=MemoryPool,name=G1 Survivor Space", "Usage.committed", "g1 survivor committed"),
    PS_SURVIVOR_COMMITTED("java.lang:type=MemoryPool,name=PS Survivor Space", "Usage.committed", "ps survivor committed"),
    PAR_SURVIVOR_COMMITTED("java.lang:type=MemoryPool,name=Par Survivor Space", "Usage.committed", "par survivor committed"),
    TENURED_GEN_USAGE("java.lang:type=MemoryPool,name=Tenured Gen", "Usage.used", "tenured gen used"),
    G1_OLD_GEN_USAGE("java.lang:type=MemoryPool,name=G1 Old Gen", "Usage.used", "g1 old gen used"),
    PS_OLD_GEN_USAGE("java.lang:type=MemoryPool,name=PS Old Gen", "Usage.used", "ps old gen used"),
    CMS_OLD_GEN_USAGE("java.lang:type=MemoryPool,name=CMS Old Gen", "Usage.used", "cms old gen used"),
    TENURED_GEN_TOTAL("java.lang:type=MemoryPool,name=Tenured Gen", "Usage.max", "tenured gen total"),
    G1_OLD_GEN_TOTAL("java.lang:type=MemoryPool,name=G1 Old Gen", "Usage.max", "g1 old gen total"),
    PS_OLD_GEN_TOTAL("java.lang:type=MemoryPool,name=PS Old Gen", "Usage.max", "ps old gen total"),
    CMS_OLD_GEN_TOTAL("java.lang:type=MemoryPool,name=CMS Old Gen", "Usage.max", "cmd old gen total"),
    TENURED_GEN_COMMITTED("java.lang:type=MemoryPool,name=Tenured Gen", "Usage.committed", "tenured gen committed"),
    G1_OLD_GEN_COMMITTED("java.lang:type=MemoryPool,name=G1 Old Gen", "Usage.committed", "g1 old gen committed"),
    PS_OLD_GEN_COMMITTED("java.lang:type=MemoryPool,name=PS Old Gen", "Usage.committed", "ps old gen committed"),
    CMS_OLD_GEN_COMMITTED("java.lang:type=MemoryPool,name=CMS Old Gen", "Usage.committed", "cms old gen committed"),
    CODE_CACHE_USAGE("java.lang:type=MemoryPool,name=Code Cache", "Usage.used", "code cache used"),
    CODE_CACHE_TOTAL("java.lang:type=MemoryPool,name=Code Cache", "Usage.max", "code cache total"),
    CODE_CACHE_COMMITTED("java.lang:type=MemoryPool,name=Code Cache", "Usage.committed", "code cache committed"),
    COMPRESSED_CLASS_SPACE_USAGE("java.lang:type=MemoryPool,name=Compressed Class Space", "Usage.used", "compressed class space used"),
    COMPRESSED_CLASS_SPACE_TOTAL("java.lang:type=MemoryPool,name=Compressed Class Space", "Usage.max", "compressed class space total"),
    COMPRESSED_CLASS_SPACE_COMMITTED("java.lang:type=MemoryPool,name=Compressed Class Space", "Usage.committed", "compressed class space committed"),
    METASPACE_USAGE("java.lang:type=MemoryPool,name=Metaspace", "Usage.used", "metaspace used"),
    METASPACE_TOTAL("java.lang:type=MemoryPool,name=Metaspace", "Usage.max", "metaspace total"),
    METASPACE_COMMITTED("java.lang:type=MemoryPool,name=Metaspace", "Usage.committed", "metaspace committed"),
    CLASS_LOADING_TOTAL("java.lang:type=ClassLoading", "TotalLoadedClassCount", "classes loaded total"),
    CLASS_LOADING_LOADED("java.lang:type=ClassLoading", "LoadedClassCount", "classes loaded"),
    CLASS_LOADING_UNLOADED("java.lang:type=ClassLoading", "UnloadedClassCount", "classes unloaded"),
    GC_COPY_TIME("java.lang:type=GarbageCollector,name=Copy", "CollectionTime", "gc copy collection time"),
    GC_COPY_COUNT("java.lang:type=GarbageCollector,name=Copy", "CollectionCount", "gc copy collection count"),
    GC_PAR_NEW_TIME("java.lang:type=GarbageCollector,name=ParNew", "CollectionTime", "gc parNew collection time"),
    GC_PAR_NEW_COUNT("java.lang:type=GarbageCollector,name=ParNew", "CollectionCount", "gc parNew collection count"),
    GC_PS_SCAVENGE_TIME("java.lang:type=GarbageCollector,name=PS Scavenge", "CollectionTime", "gc ps scavenge collection time"),
    GC_PS_SCAVENGE_COUNT("java.lang:type=GarbageCollector,name=PS Scavenge", "CollectionCount", "gc ps scavenge collection count"),
    GC_G1_YOUNG_GENERATION_TIME("java.lang:type=GarbageCollector,name=G1 Young Generation", "CollectionTime", "gc g1 young generation collection time"),
    GC_G1_YOUNG_GENERATION_COUNT("java.lang:type=GarbageCollector,name=G1 Young Generation", "CollectionCount", "gc g1 young generation collection count"),
    GC_MARK_SWEEP_TIME("java.lang:type=GarbageCollector,name=MarkSweepCompact", "CollectionTime", "gc markSweep collection time"),
    GC_MARK_SWEEP_COUNT("java.lang:type=GarbageCollector,name=MarkSweepCompact", "CollectionCount", "gc markSweep collection count"),
    GC_PS_MARK_SWEEP_TIME("java.lang:type=GarbageCollector,name=PS MarkSweep", "CollectionTime", "gc ps markSweep collection time"),
    GC_PS_MARK_SWEEP_COUNT("java.lang:type=GarbageCollector,name=PS MarkSweep", "CollectionCount", "gc ps markSweep collection count"),
    GC_G1_OLD_GENERATION_TIME("java.lang:type=GarbageCollector,name=G1 Old Generation", "CollectionTime", "gc g1 old Generation collection time"),
    GC_G1_OLD_GENERATION_COUNT("java.lang:type=GarbageCollector,name=G1 Old Generation", "CollectionCount", "gc g1 old Generation collection count"),
    THREADING_COUNT("java.lang:type=Threading", "ThreadCount", "thread count"),
    CPU_USAGE("java.lang:type=OperatingSystem", "ProcessCpuLoad", "CPU"),
    LOAD_AVERAGE("java.lang:type=OperatingSystem", "SystemLoadAverage", "load average"),
    AVAILABLE_PROCESSORS("java.lang:type=OperatingSystem", "AvailableProcessors", "available processors"),
    TOTAL_PHYSICAL_MEMORY("java.lang:type=OperatingSystem", "TotalPhysicalMemorySize", "total physical memory size"),
    JVM_UPTIME("java.lang:type=Runtime", "Uptime", "jvm uptime");

    private final String beanQuery;
    private final String attribute;
    private final String monitorMessage;
    private final String metricName;

    private SupportedJMXBean(String beanQuery, String attribute, String monitorMessage) {
        this.beanQuery = beanQuery;
        this.attribute = attribute;
        this.monitorMessage = monitorMessage;
        this.metricName = beanQuery + ":" + monitorMessage;
    }

    public String getAttribute() {
        return this.attribute;
    }

    public String getBeanQuery() {
        return this.beanQuery;
    }

    public String getMonitorMessage() {
        return this.monitorMessage;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public JMXBean getJMXBean() {
        return new JMXBean(this.beanQuery, this.attribute, this.monitorMessage);
    }

    private static class Constants {
        public static final String JAVA_LANG_TYPE = "java.lang:type";
        public static final String JAVA_LANG_TYPE_MEMORY = "java.lang:type=Memory";
        public static final String JAVA_LANG_TYPE_RUNTIME = "java.lang:type=Runtime";
        public static final String JAVA_LANG_TYPE_THREADING = "java.lang:type=Threading";
        public static final String JAVA_LANG_TYPE_MEMORY_POOL = "java.lang:type=MemoryPool";
        public static final String JAVA_LANG_TYPE_CLASS_LOADING = "java.lang:type=ClassLoading";
        public static final String JAVA_LANG_TYPE_OPERATING_SYSTEM = "java.lang:type=OperatingSystem";
        public static final String JAVA_LANG_TYPE_GARBAGE_COLLECTOR = "java.lang:type=GarbageCollector";
        public static final String MEMORY_POOL_EDEN_SPACE = "java.lang:type=MemoryPool,name=Eden Space";
        public static final String MEMORY_POOL_G1_EDEN_SPACE = "java.lang:type=MemoryPool,name=G1 Eden Space";
        public static final String MEMORY_POOL_PS_EDEN_SPACE = "java.lang:type=MemoryPool,name=PS Eden Space";
        public static final String MEMORY_POOL_PAR_EDEN_SPACE = "java.lang:type=MemoryPool,name=Par Eden Space";
        public static final String MEMORY_POOL_SURVIVOR_SPACE = "java.lang:type=MemoryPool,name=Survivor Space";
        public static final String MEMORY_POOL_G1_SURVIVOR_SPACE = "java.lang:type=MemoryPool,name=G1 Survivor Space";
        public static final String MEMORY_POOL_PS_SURVIVOR_SPACE = "java.lang:type=MemoryPool,name=PS Survivor Space";
        public static final String MEMORY_POOL_PAR_SURVIVOR_SPACE = "java.lang:type=MemoryPool,name=Par Survivor Space";
        public static final String MEMORY_POOL_TENURED_GEN = "java.lang:type=MemoryPool,name=Tenured Gen";
        public static final String MEMORY_POOL_G1_OLD_GEN = "java.lang:type=MemoryPool,name=G1 Old Gen";
        public static final String MEMORY_POOL_PS_OLD_GEN = "java.lang:type=MemoryPool,name=PS Old Gen";
        public static final String MEMORY_POOL_CMS_OLD_GEN = "java.lang:type=MemoryPool,name=CMS Old Gen";
        public static final String MEMORY_POOL_CODE_CACHE = "java.lang:type=MemoryPool,name=Code Cache";
        public static final String MEMORY_POOL_METASPACE = "java.lang:type=MemoryPool,name=Metaspace";
        public static final String MEMORY_POOL_COMPRESSED_CLASS_SPACE = "java.lang:type=MemoryPool,name=Compressed Class Space";
        public static final String GARBAGE_COLLECTOR_COPY = "java.lang:type=GarbageCollector,name=Copy";
        public static final String GARBAGE_COLLECTOR_PAR_NEW = "java.lang:type=GarbageCollector,name=ParNew";
        public static final String GARBAGE_COLLECTOR_PS_SCAVENGE = "java.lang:type=GarbageCollector,name=PS Scavenge";
        public static final String GARBAGE_COLLECTOR_G1_YOUNG_GENERATION = "java.lang:type=GarbageCollector,name=G1 Young Generation";
        public static final String GARBAGE_COLLECTOR_MARK_SWEEP_COMPACT = "java.lang:type=GarbageCollector,name=MarkSweepCompact";
        public static final String GARBAGE_COLLECTOR_PS_MARK_SWEEP = "java.lang:type=GarbageCollector,name=PS MarkSweep";
        public static final String GARBAGE_COLLECTOR_G1_OLD_GENERATION = "java.lang:type=GarbageCollector,name=G1 Old Generation";
        public static final String ATTRIBUTE_USAGE_MAX = "Usage.max";
        public static final String ATTRIBUTE_USAGE_USED = "Usage.used";
        public static final String ATTRIBUTE_USAGE_COMMITTED = "Usage.committed";
        public static final String ATTRIBUTE_COLLECTION_TIME = "CollectionTime";
        public static final String ATTRIBUTE_COLLECTION_COUNT = "CollectionCount";

        private Constants() {
        }
    }
}

