/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.domain.monitoring;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JvmMemoryArgumentsReader {
    private static final Logger LOGGER = LogManager.getLogger(JvmMemoryArgumentsReader.class);
    private static final RuntimeMXBean runtimeBean = ManagementFactory.getRuntimeMXBean();

    public static long getXmxValue() {
        List<String> arguments = runtimeBean.getInputArguments();
        for (String argument : arguments) {
            if (!argument.startsWith("-Xmx")) continue;
            return JvmMemoryArgumentsReader.parseMemoryValue(argument.substring(4));
        }
        LOGGER.debug("Xmx argument not found in JVM arguments");
        return -1L;
    }

    public static long getXmsValue() {
        LOGGER.debug("Reading Xms value from JVM arguments");
        List<String> arguments = runtimeBean.getInputArguments();
        for (String argument : arguments) {
            if (!argument.startsWith("-Xms")) continue;
            return JvmMemoryArgumentsReader.parseMemoryValue(argument.substring(4));
        }
        LOGGER.debug("Xms argument not found in JVM arguments");
        return -1L;
    }

    public static List<String> getAllJvmArguments() {
        return runtimeBean.getInputArguments();
    }

    public static long parseMemoryValue(String value) {
        try {
            if (value == null || value.trim().isEmpty()) {
                throw new IllegalArgumentException("Memory value cannot be null or empty");
            }
            value = value.trim();
            String numericPart = value.replaceAll("[^0-9]", "");
            String unit = value.replaceAll("[0-9]", "").toLowerCase();
            if (numericPart.isEmpty()) {
                throw new IllegalArgumentException("No numeric value found in: " + value);
            }
            long numericValue = Long.parseLong(numericPart);
            switch (unit) {
                case "t": 
                case "tb": {
                    return numericValue * 1024L * 1024L * 1024L * 1024L;
                }
                case "g": 
                case "gb": {
                    return numericValue * 1024L * 1024L * 1024L;
                }
                case "m": 
                case "mb": {
                    return numericValue * 1024L * 1024L;
                }
                case "k": 
                case "kb": {
                    return numericValue * 1024L;
                }
                case "b": 
                case "": {
                    return numericValue;
                }
            }
            throw new IllegalArgumentException("Unknown memory unit: " + unit);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid numeric value in: " + value, e);
        }
    }
}

