/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.configuration.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.clients.AuthenticationProxyFactory;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.common.AuthenticationProxyConfiguration;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Named(value="UpdaterAuthProxyClient")
@Singleton
public class AuthProxyClientProvider {
    @Configurable(value="{}")
    private AuthenticationProxyConfiguration authenticationProxy;
    @Inject
    private AuthenticationProxyFactory authenticationProxyFactory;

    public AuthenticationProxyClient getClient(String configurationDirectory) {
        return this.getClient(configurationDirectory, null);
    }

    public AuthenticationProxyClient getClient(String configurationDirectory, String previousInstalledAgentVersion) {
        System.setProperty("mule.agent.configuration.folder", configurationDirectory);
        if (this.hasAuthProxyConfiguration()) {
            return this.authenticationProxyFactory.create(this.authenticationProxy, new ObjectMapper(), previousInstalledAgentVersion);
        }
        return null;
    }

    private boolean hasAuthProxyConfiguration() {
        return this.authenticationProxy.getSecurity() != null && this.authenticationProxy.getSecurity().getKeyStoreFile() != null && this.authenticationProxy.getSecurity().getKeyStorePassword() != null && this.authenticationProxy.getSecurity().getTrustStoreFile() != null && this.authenticationProxy.getSecurity().getKeyStoreAlias() != null && this.authenticationProxy.getSecurity().getKeyStoreAliasPassword() != null;
    }
}

