/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.clients.adapters;

import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import kotlin.Pair;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.uri.Uri;

public class OkHttpCallAsyncHttpResponseAdapter
implements org.asynchttpclient.Response {
    private static final Logger LOGGER = LogManager.getLogger(OkHttpCallAsyncHttpResponseAdapter.class);
    private Call syncCall;
    private Response syncResponse;

    public OkHttpCallAsyncHttpResponseAdapter performRequest(OkHttpClient okHttpClient, Request request) throws IOException {
        this.syncCall = okHttpClient.newCall(request);
        this.syncResponse = this.syncCall.execute();
        return this;
    }

    public int getStatusCode() {
        return this.syncResponse.code();
    }

    public String getStatusText() {
        return this.syncResponse.message();
    }

    public byte[] getResponseBodyAsBytes() {
        try {
            return this.syncResponse.body().bytes();
        }
        catch (IOException e) {
            LOGGER.error("Could not extract response body", (Throwable)e);
            throw new RuntimeException("Could not extract response body", e);
        }
    }

    public ByteBuffer getResponseBodyAsByteBuffer() {
        try {
            byte[] body = this.syncResponse.body().bytes();
            return ByteBuffer.wrap(body, 0, body.length);
        }
        catch (IOException e) {
            LOGGER.error("Could not extract response body", (Throwable)e);
            throw new RuntimeException("Could not extract response body", e);
        }
    }

    public InputStream getResponseBodyAsStream() {
        return this.syncResponse.body().byteStream();
    }

    public String getResponseBody(Charset charset) {
        try {
            return new String(this.syncResponse.body().bytes(), charset);
        }
        catch (IOException e) {
            LOGGER.error("Could not extract response body", (Throwable)e);
            throw new RuntimeException("Could not extract response body", e);
        }
    }

    public String getResponseBody() {
        try {
            return this.syncResponse.body().string();
        }
        catch (IOException e) {
            LOGGER.error("Could not extract response body", (Throwable)e);
            throw new RuntimeException("Could not extract response body", e);
        }
    }

    public Uri getUri() {
        URI nativeURI = this.syncCall.request().url().uri();
        return new Uri(nativeURI.getScheme(), nativeURI.getUserInfo(), nativeURI.getHost(), nativeURI.getPort(), nativeURI.getPath(), nativeURI.getQuery(), nativeURI.getFragment());
    }

    public String getContentType() {
        return this.syncResponse.header("Content-Type");
    }

    public String getHeader(CharSequence name) {
        return this.syncResponse.header(name.toString());
    }

    public List<String> getHeaders(CharSequence name) {
        return this.syncResponse.headers(name.toString());
    }

    public HttpHeaders getHeaders() {
        DefaultHttpHeaders nettyHeaders = new DefaultHttpHeaders();
        this.syncResponse.headers().forEach(arg_0 -> OkHttpCallAsyncHttpResponseAdapter.lambda$getHeaders$0((HttpHeaders)nettyHeaders, arg_0));
        return nettyHeaders;
    }

    public boolean isRedirected() {
        return this.syncResponse.isRedirect();
    }

    public List<Cookie> getCookies() {
        return new ArrayList<Cookie>();
    }

    public boolean hasResponseStatus() {
        return this.syncResponse.code() != 0;
    }

    public boolean hasResponseHeaders() {
        return this.syncResponse.headers() != null && this.syncResponse.headers().size() > 0;
    }

    public boolean hasResponseBody() {
        try {
            return this.syncResponse.peekBody(64L).bytes().length > 0;
        }
        catch (IOException e) {
            LOGGER.error("Could not extract response body", (Throwable)e);
            return false;
        }
    }

    public SocketAddress getRemoteAddress() {
        return null;
    }

    public SocketAddress getLocalAddress() {
        return null;
    }

    private static /* synthetic */ void lambda$getHeaders$0(HttpHeaders nettyHeaders, Pair pair) {
        nettyHeaders.add((String)pair.component1(), pair.component2());
    }
}

