/*
 * Decompiled with CFR 0.152.
 */
package org.raml.yagi.framework.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.Range;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.FloatingNode;
import org.raml.yagi.framework.nodes.IntegerNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class RangeValueRule
extends Rule {
    private Range<Number> range;
    private final Comparator<Number> numberComparator = Comparator.comparingDouble(Number::doubleValue);

    public RangeValueRule(Number min, Number max) {
        this.range = Range.of((Object)min, (Object)max, this.numberComparator);
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode || node instanceof FloatingNode) {
            return true;
        }
        if (node instanceof SimpleTypeNode) {
            try {
                Long.parseLong(((SimpleTypeNode)node).getLiteralValue());
                return true;
            }
            catch (NumberFormatException parseLongException) {
                try {
                    Double.parseDouble(((SimpleTypeNode)node).getLiteralValue());
                    return true;
                }
                catch (NumberFormatException parseDoubleException) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.validate(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        return ErrorNodeFactory.createInvalidRangeValue(node, (Number)this.range.getMinimum(), (Number)this.range.getMaximum());
    }

    private boolean validate(Node node) {
        if (node instanceof IntegerNode) {
            Long value = ((IntegerNode)node).getValue();
            return this.range.contains((Object)value);
        }
        if (node instanceof FloatingNode) {
            BigDecimal value = ((FloatingNode)node).getValue();
            return this.range.contains((Object)value.doubleValue());
        }
        if (node instanceof SimpleTypeNode) {
            try {
                long parseLong = Long.parseLong(((StringNode)node).getValue());
                return this.range.contains((Object)parseLong);
            }
            catch (NumberFormatException parseLongException) {
                try {
                    double parseDouble = Double.parseDouble(((StringNode)node).getValue());
                    return this.range.contains((Object)parseDouble);
                }
                catch (NumberFormatException parseDoubleException) {
                    return false;
                }
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return "Maximum value";
    }
}

