/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.uri;

import com.mulesoft.mule.runtime.gw.client.exception.UriBuilderException;
import com.mulesoft.mule.runtime.gw.client.uri.UriBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.message.BasicNameValuePair;

public class HttpClientUriBuilder
implements UriBuilder {
    private String baseUri = "";
    private String path = "";
    private final List<NameValuePair> queryParams = new LinkedList<NameValuePair>();

    @Override
    public HttpClientUriBuilder fromUri(String baseUri) {
        if (Objects.nonNull(baseUri)) {
            this.baseUri = baseUri;
        }
        return this;
    }

    @Override
    public HttpClientUriBuilder appendPath(String path) {
        if (Objects.nonNull(path)) {
            this.path = this.appendPath(this.path, path);
        }
        return this;
    }

    @Override
    public HttpClientUriBuilder queryParam(String name, String value) {
        if (Objects.nonNull(name) && Objects.nonNull(value)) {
            this.queryParams.add((NameValuePair)new BasicNameValuePair(name, value));
        }
        return this;
    }

    @Override
    public URI build(Object ... params) {
        String parametrizedPath = this.replaceParams(this.path, params);
        try {
            URIBuilder builder = new URIBuilder(this.baseUri);
            if (!parametrizedPath.isEmpty() || !this.queryParams.isEmpty()) {
                builder.setPath(this.appendPath(Optional.ofNullable(builder.getPath()).orElse("/"), parametrizedPath));
            }
            if (!this.queryParams.isEmpty()) {
                builder.setParameters(this.queryParams);
            }
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new UriBuilderException(e);
        }
    }

    private String appendPath(String base, String append) {
        return base.endsWith("/") && append.startsWith("/") ? base + append.substring(1) : base + append;
    }

    private String replaceParams(String target, Object ... params) {
        return String.format(target.replaceAll("\\{.*?\\}", "%s"), params);
    }
}

