/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.httpclient.interceptors;

import com.mulesoft.mule.runtime.gw.client.httpclient.interceptors.HttpRequestResponseInterceptor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentEnricherInterceptor
implements HttpRequestResponseInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAgentEnricherInterceptor.class);
    private String agent;

    public UserAgentEnricherInterceptor() {
        String gatewayVersion = MuleManifest.getProductVersion();
        String javaVersion = System.getProperty("java.version");
        try {
            String hostName = InetAddress.getLocalHost().getHostName();
            this.agent = String.format("API Gateway %s (Java/%s) (%s)", gatewayVersion, javaVersion, hostName);
        }
        catch (UnknownHostException e) {
            LOGGER.warn("Error obtaining hostname. Header User-Agent will be sent without hostname information. {}.", (Object)e.getMessage());
            this.agent = String.format("API Gateway %s (Java/%s)", gatewayVersion, javaVersion);
        }
    }

    public void process(HttpRequest httpRequest, HttpContext httpContext) {
        httpRequest.setHeader("User-Agent", this.agent);
    }

    public void process(HttpResponse httpResponse, HttpContext httpContext) {
    }
}

