/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.gw.client.auth;

import com.mulesoft.mule.runtime.gw.api.time.DateTime;
import java.util.Optional;

public class AccessTokens {
    private final String coreServicesToken;
    private final String apiManagerToken;
    private final String rootOrgId;
    private final DateTime expires;

    AccessTokens(String coreServicesToken) {
        this(coreServicesToken, null, null, null);
    }

    AccessTokens(String coreServicesToken, String apiManagerToken, String rootOrgId, DateTime secondsToExpiration) {
        this.coreServicesToken = coreServicesToken;
        this.apiManagerToken = apiManagerToken;
        this.rootOrgId = rootOrgId;
        this.expires = secondsToExpiration;
    }

    public static AccessTokens invalidTokens() {
        return new AccessTokens(null, null, null, null);
    }

    public String getCoreServicesToken() {
        return this.coreServicesToken;
    }

    public String getApiManagerToken() {
        return this.apiManagerToken;
    }

    public DateTime getExpirationTime() {
        return this.expires;
    }

    public boolean haveExpired() {
        return this.expires != null && DateTime.now().isAfter(this.expires);
    }

    public Optional<String> getRootOrgId() {
        return Optional.ofNullable(this.rootOrgId);
    }
}

