/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.ui.PublishToExchangeWizardPageOne;
import org.mule.tooling.maven.ui.PublishToExchangeWizardPageTwo;
import org.mule.tooling.maven.ui.actions.ExchangeMavenDeployer;
import org.mule.tooling.maven.ui.actions.ResultCallback;
import org.mule.tooling.maven.ui.model.ExchangeProjectAttributes;
import org.mule.tooling.maven.ui.wizards.ExchangeMetrics;
import org.mule.tooling.ui.widgets.util.LinkMessageDialog;

public class PublishToExchangeWizard
extends Wizard {
    private PublishToExchangeWizardPageOne pageOne;
    private PublishToExchangeWizardPageTwo pageTwo;
    private MavenMuleProjectDecorator muleMavenProject;
    private ExchangeProjectAttributes backupProject;
    private ExchangeMetrics exchangeMetrics;

    public PublishToExchangeWizard(MavenMuleProjectDecorator muleMavenProject, ExchangeProjectAttributes backupProject) {
        this.pageOne = new PublishToExchangeWizardPageOne(muleMavenProject);
        this.pageTwo = new PublishToExchangeWizardPageTwo(muleMavenProject);
        this.muleMavenProject = muleMavenProject;
        this.backupProject = backupProject;
        this.exchangeMetrics = new ExchangeMetrics();
        this.setWindowTitle("Publish to Exchange");
    }

    public boolean performFinish() {
        block10: {
            ResultCallback resultCallback = new ResultCallback(){

                @Override
                public void onSuccess() {
                    PublishToExchangeWizard.this.getShell().getDisplay().syncExec(() -> {
                        PublishToExchangeWizard.this.exchangeMetrics.trackPublishToExchangeCompleted(PublishToExchangeWizard.this.muleMavenProject.getProjectType(), PublishToExchangeWizard.this.pageOne.getCurrentOrganization(), PublishToExchangeWizard.this.pageTwo.getAmountTags(), PublishToExchangeWizard.this.pageTwo.getAmountCategories());
                        String url = PlatformUrls.getActiveExchangeUrl() + PublishToExchangeWizard.this.pageOne.getGroupId() + "/" + PublishToExchangeWizard.this.pageOne.getArtifactId();
                        String linkText = "Link to your project: <a>" + url + "</a>";
                        String titleText = "Publishment complete";
                        String messageText = "Your project has been successfully published";
                        LinkMessageDialog dialog = new LinkMessageDialog(PublishToExchangeWizard.this.getShell(), titleText, messageText, 2, 0, new String[]{"OK"}, linkText, url);
                        dialog.open();
                    });
                }

                @Override
                public void onFailure() {
                    Display.getDefault().syncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Publishment failed", (String)"The project failed to be published, check console for more information"));
                }
            };
            try {
                int start = MessageDialog.open((int)4, (Shell)Display.getCurrent().getActiveShell(), (String)"Publish to Exchange", (String)this.getWarningMessage(), (int)0, (String[])new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL});
                if (start == 0) {
                    this.pageOne.saveChanges();
                    this.pageTwo.saveChanges();
                    this.exchangeMetrics.trackPublishToExchangeStart(this.muleMavenProject.getProjectType(), this.pageOne.getCurrentOrganization(), this.pageTwo.getAmountTags(), this.pageTwo.getAmountCategories());
                    if (this.pageOne.getMavenInfoComponent().existInExchange()) {
                        MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Publishment failed", (String)"An asset with that version number has been created previously. Enter a higher version number and try again.");
                        return false;
                    }
                    ExchangeMavenDeployer runnable = new ExchangeMavenDeployer(this.muleMavenProject, this.pageOne.getCurrentOrganization(), this.pageOne.getDeployablePom(), resultCallback);
                    this.getContainer().run(true, false, (IRunnableWithProgress)runnable);
                    break block10;
                }
                return false;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                return false;
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            finally {
                this.revertChangesIfNeeded();
                this.exchangeMetrics.trackPublishToExchangeSaveToPom(this.pageTwo.isSaveChangesToPomSelected());
            }
        }
        return true;
    }

    private String getWarningMessage() {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append("Once the process has started it cannot be cancelled.\n\n");
        if (this.muleMavenProject.hasExchangeDocsFolder()) {
            messageBuilder.append("The exchange-docs folder will override your current documentation in Exchange and it cannot be recovered. ");
            messageBuilder.append("Delete the exchange-docs folder if you do not want this to happen.\n\n");
        }
        messageBuilder.append("Would you like to proceed?");
        return messageBuilder.toString();
    }

    public void addPages() {
        this.addPage((IWizardPage)this.pageOne);
        this.addPage((IWizardPage)this.pageTwo);
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public boolean canFinish() {
        return this.getContainer().getCurrentPage().equals((Object)this.pageTwo) && this.pageTwo.isValid();
    }

    private void revertChangesIfNeeded() {
        if (!this.pageTwo.isSaveChangesToPomSelected()) {
            this.muleMavenProject.setArtifactId(this.backupProject.getArtifactId());
            this.muleMavenProject.setGroupId(this.backupProject.getGroupId());
            this.muleMavenProject.setVersion(this.backupProject.getVersion());
            this.muleMavenProject.setName(this.backupProject.getName());
            this.muleMavenProject.setDescription(this.backupProject.getDescription());
            if (this.backupProject.getTags().isPresent()) {
                this.muleMavenProject.setTags(this.backupProject.getTags().get());
            } else {
                this.muleMavenProject.removeTags();
            }
            if (this.backupProject.getCategories().isPresent()) {
                this.muleMavenProject.setCategories(this.backupProject.getCategories().get());
            } else {
                this.muleMavenProject.removeCategories();
            }
            if (this.backupProject.getCustomFields().isPresent()) {
                this.muleMavenProject.setCustomFields(this.backupProject.getCustomFields().get());
            } else {
                this.muleMavenProject.removeCustomFields();
            }
        }
        this.muleMavenProject.removeMulePluginClassifier();
    }

    public void setDataToPageTwo() {
        StructuredSelection selection = (StructuredSelection)this.pageOne.getMavenInfoComponent().getProjectTypeCombo().getSelection();
        this.pageTwo.setExchangeAssetData(this.pageOne.getExchangeAsset(), this.pageOne.getCurrentUser(), this.pageOne.getCurrentOrganization().getId(), (ProjectType)selection.getFirstElement());
    }
}

