/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.wizards;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.ui.common.FileChooserComposite;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class PomChooserComponent
implements WizardPagePartExtension {
    private static final String EMPTY = "unspecified";
    public static final String KEY_POM_MODEL = "pomModel";
    private static final String ERROR_MESSAGE_FILE_EMPTY = "Please select a pom file";
    private static final String ERROR_MESSAGE_FILE_INVALID = "'%s' is not a valid pom file";
    private static final String ERROR_MESSAGE_FILE_NOT_EXISTS = "Selected pom file does not exist";
    private static final String ERROR_MESSAGE_NOT_POM = "The selected file is either not a pom or is not well formed";
    private static final Object GAV_SEPARATOR = ":";
    @WizardContext
    private PartStatusHandler statusHandler;
    private FileChooserComposite fileChooser;
    private Label gavText;

    public Control createControl(Composite parent) {
        Group pomGroup = UiUtils.createGroupWithTitle((Composite)parent, (String)"Maven Settings", (int)2);
        this.createLabel((Composite)pomGroup, "POM File:", "Specify the location of the project's POM file to import.");
        this.createFileChooser((Composite)pomGroup);
        this.createLabel((Composite)pomGroup, "Coordinates:", "Maven coordinates (group id : artifact id : version) of the selected POM file");
        this.gavText = this.createText((Composite)pomGroup);
        return pomGroup;
    }

    private Label createText(Composite pomGroup) {
        Label text = new Label(pomGroup, 2048);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)text);
        return text;
    }

    private void createLabel(Composite pomGroup, String text, String toolTip) {
        Label locationLabel = new Label(pomGroup, 0);
        locationLabel.setText(text);
        locationLabel.setToolTipText(toolTip);
        GridDataFactory.swtDefaults().hint(100, -1).applyTo((Control)locationLabel);
    }

    private void createFileChooser(Composite pomGroup) {
        this.fileChooser = new FileChooserComposite(pomGroup, 0);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.fileChooser);
        this.fileChooser.addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                PomChooserComponent.this.onPomFileChanged();
            }
        });
    }

    private void setEmptyPomDetails() {
        this.gavText.setText(EMPTY);
        this.gavText.setForeground(this.getDisplay().getSystemColor(33));
    }

    private Display getDisplay() {
        Display current = Display.getCurrent();
        return current != null ? current : Display.getDefault();
    }

    private void onPomFileChanged() {
        String filePath = this.fileChooser.getFilePath();
        if (StringUtils.isEmpty((String)filePath)) {
            this.statusHandler.setErrorMessage((WizardPagePartExtension)this, ERROR_MESSAGE_FILE_EMPTY);
            this.statusHandler.setPartComplete((WizardPagePartExtension)this, false);
            this.setEmptyPomDetails();
        } else if (filePath.endsWith(".xml")) {
            File pomFile = new File(filePath);
            this.checkPossibleFile(pomFile);
        } else {
            this.statusHandler.setErrorMessage((WizardPagePartExtension)this, String.format(ERROR_MESSAGE_FILE_INVALID, new File(filePath).getName()));
            this.statusHandler.setPartComplete((WizardPagePartExtension)this, false);
            this.setEmptyPomDetails();
        }
    }

    private void checkPossibleFile(File pomFile) {
        if (pomFile.exists()) {
            Model pomModel = MavenUtils.getPomModel((File)pomFile);
            this.checkPossiblePomModel(pomModel);
        } else {
            this.statusHandler.setErrorMessage((WizardPagePartExtension)this, ERROR_MESSAGE_FILE_NOT_EXISTS);
            this.statusHandler.setPartComplete((WizardPagePartExtension)this, false);
            this.setEmptyPomDetails();
        }
    }

    private void checkPossiblePomModel(Model pomModel) {
        if (pomModel != null) {
            this.statusHandler.notifyUpdate((WizardPagePartExtension)this, KEY_POM_MODEL, (Object)pomModel);
            this.statusHandler.clearErrors((WizardPagePartExtension)this);
            this.updatePomDetails(pomModel);
        } else {
            this.statusHandler.setErrorMessage((WizardPagePartExtension)this, ERROR_MESSAGE_NOT_POM);
            this.setEmptyPomDetails();
        }
        this.statusHandler.setPartComplete((WizardPagePartExtension)this, pomModel != null);
    }

    private void updatePomDetails(Model pomModel) {
        Parent parent = pomModel.getParent();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getGroupId(pomModel, parent));
        stringBuilder.append(GAV_SEPARATOR);
        stringBuilder.append(this.getArtifactId(pomModel));
        stringBuilder.append(GAV_SEPARATOR);
        stringBuilder.append(this.getVersion(pomModel, parent));
        this.gavText.setText(stringBuilder.toString());
        this.gavText.setForeground(null);
    }

    String getArtifactId(Model pomModel) {
        return pomModel.getArtifactId();
    }

    String getVersion(Model pomModel, Parent parent) {
        if (pomModel.getVersion() != null) {
            return pomModel.getVersion();
        }
        if (parent != null && parent.getVersion() != null) {
            return parent.getVersion();
        }
        return EMPTY;
    }

    String getGroupId(Model pomModel, Parent parent) {
        String groupId = pomModel.getGroupId();
        if (groupId != null) {
            return groupId;
        }
        if (parent != null && parent.getGroupId() != null) {
            return parent.getGroupId();
        }
        return EMPTY;
    }

    public void initializeDefaults() {
        this.fileChooser.setFilePath("");
        this.setEmptyPomDetails();
    }

    public void performFinish(IProgressMonitor monitor) {
    }

    public void setStatusHandler(PartStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }
}

