/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.wizards;

import java.util.Optional;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.auth.Organization;
import org.mule.tooling.core.m2.ProjectType;

public class ExchangeMetrics {
    public void trackPublishToExchangeCompleted(Optional<ProjectType> projectType, Organization org, int amountTags, int amountCategories) {
        this.trackPublishToExchange(Events.PUBLISH_TO_EXCHANGE_COMPLETED, projectType, org, amountTags, amountCategories);
    }

    public void trackPublishToExchangeStart(Optional<ProjectType> projectType, Organization org, int amountTags, int amountCategories) {
        this.trackPublishToExchange(Events.PUBLISH_TO_EXCHANGE, projectType, org, amountTags, amountCategories);
    }

    public void trackPublishToExchangeSaveToPom(boolean areChangesSavedToPom) {
        AnalyticsRecordsFactory.single((String)Events.PUBLISH_TO_EXCHANGE_SAVE_TO_POM, (String[])new String[]{"saved", String.valueOf(areChangesSavedToPom)}).track();
    }

    private void trackPublishToExchange(String metricId, Optional<ProjectType> projectType, Organization org, int amountTags, int amountCategories) {
        AnalyticsRecordsFactory event = AnalyticsRecordsFactory.single((String)metricId);
        if (projectType.isPresent()) {
            event.addMetadata("projectType", projectType.get().toString());
        }
        if (org != null) {
            event.addMetadata("organizationId", org.getId());
        }
        event.addMetadata("PublishToExchangeAmountTags", String.valueOf(amountTags));
        event.addMetadata("PublishToExchangeAmountCategories", String.valueOf(amountCategories));
        event.track();
    }
}

