/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.wizards.ConfigureMavenHomeDialog;
import org.mule.tooling.maven.ui.wizards.PojoMavenModel;
import org.mule.tooling.ui.utils.GrayedTooltipTextListener;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.ui.wizards.extensible.PartStatusHandler;
import org.mule.tooling.ui.wizards.extensible.WizardContext;
import org.mule.tooling.ui.wizards.extensible.WizardPagePartExtension;

public class CreatePomWizardPagePartExtension
implements WizardPagePartExtension {
    private static final boolean DEFAULT_CREATE_POM = false;
    private static final String DEFAULT_ARTIFACTID = "artifact-id";
    private static final String DEFAULT_VERSION = "1.0.0-SNAPSHOT";
    private static final String GROUP_TITLE_MAVEN_SETTINGS = "Maven Settings";
    private static final String CREATE_POM_LABEL = "Use Maven";
    private static final String CONFIGURE_MAVEN_LINK_TEXT = " - (Maven is currently disabled, <a>configure Maven</a>)";
    @WizardContext
    private PartStatusHandler statusHandler;
    @WizardContext
    private String projectName;
    @WizardContext
    private IMuleProject muleProject;
    private PojoMavenModel mavenModel = new PojoMavenModel(false, MavenUIPlugin.getDefault().getPreferences().getDefaultGroupId(), "artifact-id", "1.0.0-SNAPSHOT");
    private Button cbCreatePomCheckbox;
    private Text txtGroupId;
    private Text txtArtifactId;
    private Text txtVersion;
    private boolean erroneousState;
    private Link configureMavenLink;
    private List<Label> labels = new ArrayList<Label>(3);

    public void setProjectName(String projectName) {
        this.projectName = projectName;
        this.updateArtifactId(this.getArtifactIdFromProjectName(projectName));
    }

    public void setMuleProject(IMuleProject muleProject) {
        this.muleProject = muleProject;
    }

    public void setStatusHandler(PartStatusHandler statusHandler) {
        this.statusHandler = statusHandler;
    }

    public Control createControl(Composite parent) {
        Group mavenGroupBox = UiUtils.createGroupWithTitle((Composite)parent, (String)GROUP_TITLE_MAVEN_SETTINGS, (int)2);
        this.initializeCheckBox((Composite)mavenGroupBox);
        ModifyListener groupIdListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue = CreatePomWizardPagePartExtension.this.txtGroupId.getText();
                CreatePomWizardPagePartExtension.this.mavenModel.setGroupId(newValue);
                CreatePomWizardPagePartExtension.this.validateMavenModel();
            }
        };
        ModifyListener artifactIdListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue = CreatePomWizardPagePartExtension.this.txtArtifactId.getText();
                CreatePomWizardPagePartExtension.this.mavenModel.setArtifactId(newValue);
                CreatePomWizardPagePartExtension.this.validateMavenModel();
            }
        };
        ModifyListener versionListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String newValue = CreatePomWizardPagePartExtension.this.txtVersion.getText();
                CreatePomWizardPagePartExtension.this.mavenModel.setVersion(newValue);
                CreatePomWizardPagePartExtension.this.validateMavenModel();
            }
        };
        this.txtGroupId = this.initializeTextField(mavenGroupBox, "Group Id: ", this.mavenModel.getGroupId(), groupIdListener);
        this.txtArtifactId = this.initializeTextField(mavenGroupBox, "Artifact Id: ", this.mavenModel.getArtifactId(), artifactIdListener);
        this.txtVersion = this.initializeTextField(mavenGroupBox, "Version: ", this.mavenModel.getVersion(), versionListener);
        if (!MavenUIPlugin.getDefault().getPreferences().isGlobalMavenSupportEnabled()) {
            this.onMavenEnablementChanged(false);
        }
        this.updateComponentsEnablement();
        this.statusHandler.setPartComplete((WizardPagePartExtension)this, true);
        mavenGroupBox.layout();
        return mavenGroupBox;
    }

    private void updateArtifactId(String value) {
        String newName = !value.trim().isEmpty() ? value : DEFAULT_ARTIFACTID;
        this.txtArtifactId.setText(newName);
        this.mavenModel.setArtifactId(newName);
        this.validateMavenModel();
    }

    private void updateComponentsEnablement() {
        boolean createPom = this.mavenModel.isCreatePom();
        this.txtArtifactId.setEnabled(createPom);
        this.txtGroupId.setEnabled(createPom);
        this.txtVersion.setEnabled(createPom);
        for (Label label : this.labels) {
            label.setForeground(createPom ? GrayedTooltipTextListener.getActiveColor() : GrayedTooltipTextListener.getInactiveColor());
        }
    }

    private String getArtifactIdFromProjectName(String name) {
        return name.replaceAll(" ", "-").toLowerCase();
    }

    private Text initializeTextField(Group groupBox, String labelText, String defaultValue, ModifyListener modifyListener) {
        Label label = new Label((Composite)groupBox, 0);
        label.setText(labelText);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().align(1, 0x1000000).hint(100, -1).create());
        Text textField = new Text((Composite)groupBox, 2048);
        textField.setLayoutData((Object)new GridData(768));
        textField.setText(defaultValue);
        textField.addModifyListener(modifyListener);
        this.labels.add(label);
        return textField;
    }

    private void initializeCheckBox(Composite parentGroup) {
        Composite parent = new Composite(parentGroup, 0);
        GridDataFactory.swtDefaults().span(2, 1).applyTo((Control)parent);
        GridLayoutFactory.fillDefaults().numColumns(2).spacing(-1, 0).applyTo(parent);
        this.doCreateCheckbox(parent);
        this.doCreateConfigureLink(parent);
    }

    private void doCreateConfigureLink(final Composite parent) {
        this.configureMavenLink = new Link(parent, 0);
        this.configureMavenLink.setText(CONFIGURE_MAVEN_LINK_TEXT);
        GridDataFactory.swtDefaults().indent(0, 2).applyTo((Control)this.configureMavenLink);
        this.configureMavenLink.setForeground(GrayedTooltipTextListener.getInactiveColor());
        this.configureMavenLink.setVisible(false);
        this.configureMavenLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int returnValue = ConfigureMavenHomeDialog.open(parent.getShell());
                if (returnValue == 0) {
                    CreatePomWizardPagePartExtension.this.onMavenEnablementChanged(true);
                }
            }
        });
    }

    protected void onMavenEnablementChanged(boolean enabled) {
        this.configureMavenLink.setVisible(!enabled);
        this.cbCreatePomCheckbox.setEnabled(enabled);
        this.cbCreatePomCheckbox.setSelection(enabled);
        this.mavenModel.setCreatePom(enabled);
        this.updateComponentsEnablement();
    }

    private void doCreateCheckbox(Composite parent) {
        this.cbCreatePomCheckbox = new Button(parent, 32);
        this.cbCreatePomCheckbox.setSelection(this.mavenModel.isCreatePom());
        this.cbCreatePomCheckbox.setText(" Use Maven");
        this.cbCreatePomCheckbox.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.cbCreatePomCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CreatePomWizardPagePartExtension.this.mavenModel.setCreatePom(CreatePomWizardPagePartExtension.this.cbCreatePomCheckbox.getSelection());
                CreatePomWizardPagePartExtension.this.updateComponentsEnablement();
                CreatePomWizardPagePartExtension.this.validateMavenModel();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                CreatePomWizardPagePartExtension.this.mavenModel.setCreatePom(CreatePomWizardPagePartExtension.this.cbCreatePomCheckbox.getSelection());
                CreatePomWizardPagePartExtension.this.updateComponentsEnablement();
                CreatePomWizardPagePartExtension.this.validateMavenModel();
            }
        });
    }

    public void performFinish(IProgressMonitor monitor) {
        if (this.mavenModel.isCreatePom()) {
            try {
                try {
                    monitor.beginTask("Creating pom and enabling maven support", 100);
                    PojoMavenDependency dep = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(this.mavenModel.getGroupId())).withArtifactId(this.mavenModel.getArtifactId())).withVersion(this.mavenModel.getVersion())).build();
                    MavenResourceUtils.createPomFile((MuleProjectKind)this.muleProject.getKind(), (IJavaProject)this.muleProject.getJavaProject(), (IServerDefinition)this.muleProject.getServerDefinition(), (MavenDependency)dep, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                }
                catch (CoreException e) {
                    MavenUIPlugin.getDefault().logError("An error occurred while generating a pom.xml file for the new project", e);
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private void validateMavenModel() {
        if (!this.mavenModel.isCreatePom()) {
            this.clearErrorStatus();
        } else {
            String groupIdError = this.validateGroupIdInput(this.mavenModel.getGroupId().trim());
            if (groupIdError != null) {
                this.setErrorStatus(groupIdError);
            } else {
                String artifactIdError = this.validateArtifactIdInput(this.mavenModel.getArtifactId().trim());
                if (artifactIdError != null) {
                    this.setErrorStatus(artifactIdError);
                } else {
                    String versionError = this.validateVersionInput();
                    if (versionError != null) {
                        this.setErrorStatus(versionError);
                    } else {
                        this.clearErrorStatus();
                    }
                }
            }
        }
    }

    private void clearErrorStatus() {
        if (this.erroneousState) {
            this.erroneousState = false;
            this.statusHandler.clearErrors((WizardPagePartExtension)this);
            this.statusHandler.setPartComplete((WizardPagePartExtension)this, true);
        }
    }

    private void setErrorStatus(String message) {
        this.statusHandler.setErrorMessage((WizardPagePartExtension)this, message);
        if (!this.erroneousState) {
            this.statusHandler.setPartComplete((WizardPagePartExtension)this, false);
        }
        this.erroneousState = true;
    }

    protected String validateVersionInput() {
        if (this.mavenModel.getVersion().trim().length() == 0) {
            return "Enter a version for the artifact.";
        }
        return null;
    }

    protected String validateArtifactIdInput(String text) {
        return this.validateIdInput(text, true);
    }

    protected String validateGroupIdInput(String text) {
        return this.validateIdInput(text, false);
    }

    private String validateIdInput(String text, boolean artifact) {
        if (text == null || text.length() == 0) {
            return artifact ? "Enter an artifact id." : "Enter a group id for the artifact.";
        }
        if (text.contains(" ")) {
            return artifact ? "Artifact id cannot contain spaces." : "Group id cannot contain spaces.";
        }
        IStatus nameStatus = ResourcesPlugin.getWorkspace().validateName(text, 4);
        if (!nameStatus.isOK()) {
            return "Invalid artifact id: " + nameStatus.getMessage();
        }
        if (!text.matches("[A-Za-z0-9_\\-.]+")) {
            return String.format(artifact ? "Invalid artifact id: %s" : "Invalid group id: %s", text);
        }
        return null;
    }

    public void initializeDefaults() {
    }
}

