/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.wizards;

import java.util.Observer;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.preferences.FieldEditorListener;
import org.mule.tooling.maven.ui.preferences.MavenPreferencePage;
import org.mule.tooling.maven.ui.preferences.ObservableDirectoryFieldEditor;
import org.mule.tooling.maven.ui.preferences.TestMavenComponent;

public class ConfigureMavenHomeComponent
implements FieldEditorListener {
    private static final int HEIGHT_HINT = 200;
    private ObservableDirectoryFieldEditor mavenHomeFieldEditor;
    private TestMavenComponent testMavenComponent;
    private Observer observer;

    public ConfigureMavenHomeComponent(Observer observer) {
        this.observer = observer;
    }

    public void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(composite);
        this.mavenHomeFieldEditor = new ObservableDirectoryFieldEditor("mule_core_plugin_preference_maven_path", MavenPreferencePage.LABELS.get("mule_core_plugin_preference_maven_path"), composite, this::validateMavenHome, this);
        this.mavenHomeFieldEditor.fillIntoGrid(composite, 3);
        this.mavenHomeFieldEditor.setPreferenceStore(MavenUIPlugin.getDefault().getPreferenceStore());
        this.mavenHomeFieldEditor.load();
        this.testMavenComponent = new TestMavenComponent(composite, new Point(3, 1), true);
        String currentValue = this.mavenHomeFieldEditor.getCurrentValue();
        this.testMavenComponent.setEnabled(MavenUIPlugin.getDefault().isMavenBinaryValid(currentValue));
        this.testMavenComponent.setMavenHome(false, currentValue);
    }

    @Override
    public void valueChanged(String o, Object arg) {
        String currentValue = (String)arg;
        boolean mavenBinaryValid = MavenUIPlugin.getDefault().isMavenBinaryValid(currentValue);
        this.testMavenComponent.setEnabled(mavenBinaryValid);
        this.testMavenComponent.setMavenHome(false, currentValue);
        this.observer.update(null, arg);
    }

    public void store() {
        this.mavenHomeFieldEditor.store();
    }

    public String getCurrentValue() {
        return this.mavenHomeFieldEditor.getCurrentValue();
    }

    private boolean validateMavenHome(DirectoryFieldEditor fieldEditor, Text text) {
        return MavenUIPlugin.getDefault().isMavenBinaryValid(text.getText());
    }
}

