/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.maven.ui.utils;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.VMUtils;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.cmdline.MavenCommandLine;
import org.mule.tooling.maven.runner.MavenRunner;
import org.mule.tooling.maven.runner.MavenRunnerBuilder;
import org.mule.tooling.maven.runner.MavenRunnerConfiguration;
import org.mule.tooling.maven.ui.MavenImages;
import org.mule.tooling.maven.ui.MavenUIPlugin;
import org.mule.tooling.maven.ui.preferences.MavenPreferences;
import org.mule.tooling.maven.ui.preferences.NotificationsPreferences;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.tooling.utils.ObjectHolder;

public class MavenUiUtils {
    public static MavenRunner getMavenRunner(IJavaProject javaProject) {
        MavenPreferences preferencesAccessor = MavenUIPlugin.getDefault().getPreferences();
        return MavenRunnerBuilder.with((MavenRunnerConfiguration)preferencesAccessor).setJavaHome(VMUtils.getDefaultJvmHome((IJavaProject)javaProject)).build();
    }

    public static String getJobTitle(IMuleProject muleProject, MavenCommandLine commandline) {
        return MessageFormat.format("[{0}] {1}", muleProject.getName(), commandline.getCommand());
    }

    public static MessageConsole getMessageConsole(IMuleProject muleProject, MavenCommandLine commandline) {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        final ObjectHolder imageDescriptorHolder = new ObjectHolder();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                imageDescriptorHolder.set((Object)MavenImages.DESC_RUN_MVN);
            }
        });
        MessageConsole newMessageConsole = UiUtils.getMessageConsole((String)MavenUiUtils.getJobTitle(muleProject, commandline), (ImageDescriptor)((ImageDescriptor)imageDescriptorHolder.get()));
        ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)newMessageConsole);
        return newMessageConsole;
    }

    public static MavenDependency getDependency(MavenMuleProjectDecorator mavenProject, MavenDependency.Scope scope) {
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(mavenProject.getGroupId())).withArtifactId(mavenProject.getArtifactId())).withVersion(mavenProject.getVersion())).withScope(scope)).withType("zip")).build();
    }

    public static long computeDelay(int configuredDelayInDays) {
        LocalDateTime lastCheckDate;
        try {
            lastCheckDate = LocalDateTime.parse(NotificationsPreferences.dateOfLastCheckForUpdates(), DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss"));
        }
        catch (DateTimeParseException dateTimeParseException) {
            lastCheckDate = LocalDateTime.now();
        }
        long calculatedDelay = TimeUnit.DAYS.toMillis(configuredDelayInDays) - ChronoUnit.MILLIS.between(lastCheckDate, LocalDateTime.now());
        return calculatedDelay > 0L ? calculatedDelay : 0L;
    }
}

